\name{RescaleIntensityImageFilter}
\alias{RescaleIntensityImageFilter}
\title{RescaleIntensityImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Applies a linear transformation to the intensity levels of the input Image .
RescaleIntensityImageFilter}
\details{
RescaleIntensityImageFilter applies pixel-wise a linear transformation to the intensity values of
input image pixels. The linear transformation is defined by the user
in terms of the minimum and maximum values that the output image
should have.
The following equation gives the mapping of the intensity values
 \deqn{ outputPixel = ( inputPixel - inputMin) \cdot \frac{(outputMax - outputMin )}{(inputMax - inputMin)} + outputMin }
 All computations are performed in the precision of the input pixel's
RealType. Before assigning the computed value to the output pixel.
NOTE: In this filter the minimum and maximum values of the input image
are computed internally using the MinimumMaximumImageCalculator . Users are not supposed to set those values in this filter. If you
need a filter where you can set the minimum and maximum values of the
input, please use the IntensityWindowingImageFilter . If you want a filter that can use a user-defined linear
transformation for the intensity, then please use the ShiftScaleImageFilter .
See:
IntensityWindowingImageFilter
RescaleIntensity for the procedural interface
itk::RescaleIntensityImageFilter for the Doxygen on the original ITK class.
RescaleIntensityImageFilter}
%C++ includes: sitkRescaleIntensityImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutputMaximum() const:}{}
\item{double GetOutputMinimum() const:}{}
\item{ RescaleIntensityImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetOutputMaximum(double OutputMaximum):}{}
\item{Self SetOutputMinimum(double OutputMinimum):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RescaleIntensityImageFilter():}{
Destructor
}
}
}
