/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.util.Arrays;

public class SymmetricEncIntegrityPacket
extends InputStreamPacket
implements BCPGHeaderObject {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    int version;
    int cipherAlgorithm;
    int aeadAlgorithm;
    int chunkSize;
    byte[] salt;

    SymmetricEncIntegrityPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    SymmetricEncIntegrityPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(in, 18, newPacketFormat);
        this.version = in.read();
        if (this.version == 2) {
            this.cipherAlgorithm = in.read();
            this.aeadAlgorithm = in.read();
            this.chunkSize = in.read();
            this.salt = new byte[32];
            if (in.read(this.salt) != this.salt.length) {
                throw new EOFException("Premature end of stream.");
            }
        }
    }

    public SymmetricEncIntegrityPacket() {
        super(null, 18);
        this.version = 1;
    }

    private SymmetricEncIntegrityPacket(int version, int algorithm, int aeadAlgorithm, int chunkSize, byte[] salt) {
        super(null, 18);
        this.version = version;
        this.cipherAlgorithm = algorithm;
        this.aeadAlgorithm = aeadAlgorithm;
        this.chunkSize = chunkSize;
        this.salt = Arrays.clone((byte[])salt);
    }

    public static SymmetricEncIntegrityPacket createVersion1Packet() {
        return new SymmetricEncIntegrityPacket();
    }

    public static SymmetricEncIntegrityPacket createVersion2Packet(int algorithm, int aeadAlgorithm, int chunkSize, byte[] salt) {
        return new SymmetricEncIntegrityPacket(2, algorithm, aeadAlgorithm, chunkSize, salt);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public void encode(BCPGOutputStream bcpgOut) throws IOException {
        bcpgOut.write(this.getVersion());
        if (this.version == 2) {
            bcpgOut.write(this.cipherAlgorithm);
            bcpgOut.write(this.aeadAlgorithm);
            bcpgOut.write(this.chunkSize);
            bcpgOut.write(this.salt);
        }
    }

    public int getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public byte[] getAAData() {
        return SymmetricEncIntegrityPacket.createAAData(this.getVersion(), this.getCipherAlgorithm(), this.getAeadAlgorithm(), this.getChunkSize());
    }

    public static byte[] createAAData(int version, int cipherAlgorithm, int aeadAlgorithm, int chunkSize) {
        return new byte[]{-46, (byte)(version & 0xFF), (byte)(cipherAlgorithm & 0xFF), (byte)(aeadAlgorithm & 0xFF), (byte)(chunkSize & 0xFF)};
    }

    public byte[] getSalt() {
        return Arrays.copyOf((byte[])this.salt, (int)this.salt.length);
    }
}

