/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.scheduler.model;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.sql.spark.rest.model.LangType;
import org.opensearch.sql.spark.scheduler.model.AsyncQuerySchedulerRequest;
import org.opensearch.sql.spark.scheduler.parser.IntervalScheduleParser;

public class ScheduledAsyncQueryJobRequest
extends AsyncQuerySchedulerRequest
implements ScheduledJobParameter {
    public static final String ACCOUNT_ID_FIELD = "accountId";
    public static final String JOB_ID_FIELD = "jobId";
    public static final String DATA_SOURCE_NAME_FIELD = "dataSource";
    public static final String SCHEDULED_QUERY_FIELD = "scheduledQuery";
    public static final String QUERY_LANG_FIELD = "queryLang";
    public static final String LAST_UPDATE_TIME_FIELD = "lastUpdateTime";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String ENABLED_TIME_FIELD = "enabledTime";
    public static final String LOCK_DURATION_SECONDS = "lockDurationSeconds";
    public static final String JITTER = "jitter";
    public static final String ENABLED_FIELD = "enabled";
    private final Schedule schedule;

    public ScheduledAsyncQueryJobRequest(String accountId, String jobId, String dataSource, String scheduledQuery, LangType queryLang, Schedule schedule, boolean enabled, Instant lastUpdateTime, Instant enabledTime, Long lockDurationSeconds, Double jitter) {
        super(accountId, jobId, dataSource, scheduledQuery, queryLang, schedule, enabled, lastUpdateTime, enabledTime, lockDurationSeconds, jitter);
        this.schedule = schedule;
    }

    public String getName() {
        return this.getJobId();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    public Long getLockDurationSeconds() {
        return this.lockDurationSeconds;
    }

    @Override
    public Double getJitter() {
        return this.jitter;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.getAccountId() != null) {
            builder.field(ACCOUNT_ID_FIELD, this.getAccountId());
        }
        builder.field(JOB_ID_FIELD, this.getJobId()).field(ENABLED_FIELD, this.isEnabled());
        if (this.getDataSource() != null) {
            builder.field(DATA_SOURCE_NAME_FIELD, this.getDataSource());
        }
        if (this.getScheduledQuery() != null) {
            builder.field(SCHEDULED_QUERY_FIELD, this.getScheduledQuery());
        }
        if (this.getQueryLang() != null) {
            builder.field(QUERY_LANG_FIELD, (Object)this.getQueryLang());
        }
        if (this.getSchedule() != null) {
            builder.field(SCHEDULE_FIELD, (ToXContent)this.getSchedule());
        }
        if (this.getEnabledTime() != null) {
            builder.field(ENABLED_TIME_FIELD, this.getEnabledTime().toEpochMilli());
        }
        builder.field(LAST_UPDATE_TIME_FIELD, this.getLastUpdateTime().toEpochMilli());
        if (this.lockDurationSeconds != null) {
            builder.field(LOCK_DURATION_SECONDS, this.lockDurationSeconds);
        }
        if (this.jitter != null) {
            builder.field(JITTER, this.jitter);
        }
        builder.endObject();
        return builder;
    }

    public static ScheduledAsyncQueryJobRequest fromAsyncQuerySchedulerRequest(AsyncQuerySchedulerRequest request) {
        Instant updateTime = request.getLastUpdateTime() != null ? request.getLastUpdateTime() : Instant.now();
        return ScheduledAsyncQueryJobRequest.scheduledAsyncQueryJobRequestBuilder().accountId(request.getAccountId()).jobId(request.getJobId()).dataSource(request.getDataSource()).scheduledQuery(request.getScheduledQuery()).queryLang(request.getQueryLang()).enabled(request.isEnabled()).lastUpdateTime(updateTime).enabledTime(request.getEnabledTime()).lockDurationSeconds(request.getLockDurationSeconds()).jitter(request.getJitter()).schedule(IntervalScheduleParser.parse(request.getSchedule(), updateTime)).build();
    }

    @Generated
    public static ScheduledAsyncQueryJobRequestBuilder scheduledAsyncQueryJobRequestBuilder() {
        return new ScheduledAsyncQueryJobRequestBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledAsyncQueryJobRequest)) {
            return false;
        }
        ScheduledAsyncQueryJobRequest other = (ScheduledAsyncQueryJobRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Schedule this$schedule = this.getSchedule();
        Schedule other$schedule = other.getSchedule();
        return !(this$schedule == null ? other$schedule != null : !this$schedule.equals(other$schedule));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScheduledAsyncQueryJobRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Schedule $schedule = this.getSchedule();
        result = result * 59 + ($schedule == null ? 43 : $schedule.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ScheduledAsyncQueryJobRequest(super=" + super.toString() + ", schedule=" + String.valueOf(this.getSchedule()) + ")";
    }

    @Generated
    public static class ScheduledAsyncQueryJobRequestBuilder {
        @Generated
        private String accountId;
        @Generated
        private String jobId;
        @Generated
        private String dataSource;
        @Generated
        private String scheduledQuery;
        @Generated
        private LangType queryLang;
        @Generated
        private Schedule schedule;
        @Generated
        private boolean enabled;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private Instant enabledTime;
        @Generated
        private Long lockDurationSeconds;
        @Generated
        private Double jitter;

        @Generated
        ScheduledAsyncQueryJobRequestBuilder() {
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder scheduledQuery(String scheduledQuery) {
            this.scheduledQuery = scheduledQuery;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder queryLang(LangType queryLang) {
            this.queryLang = queryLang;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder enabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder lockDurationSeconds(Long lockDurationSeconds) {
            this.lockDurationSeconds = lockDurationSeconds;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequestBuilder jitter(Double jitter) {
            this.jitter = jitter;
            return this;
        }

        @Generated
        public ScheduledAsyncQueryJobRequest build() {
            return new ScheduledAsyncQueryJobRequest(this.accountId, this.jobId, this.dataSource, this.scheduledQuery, this.queryLang, this.schedule, this.enabled, this.lastUpdateTime, this.enabledTime, this.lockDurationSeconds, this.jitter);
        }

        @Generated
        public String toString() {
            return "ScheduledAsyncQueryJobRequest.ScheduledAsyncQueryJobRequestBuilder(accountId=" + this.accountId + ", jobId=" + this.jobId + ", dataSource=" + this.dataSource + ", scheduledQuery=" + this.scheduledQuery + ", queryLang=" + String.valueOf((Object)this.queryLang) + ", schedule=" + String.valueOf(this.schedule) + ", enabled=" + this.enabled + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", enabledTime=" + String.valueOf(this.enabledTime) + ", lockDurationSeconds=" + this.lockDurationSeconds + ", jitter=" + this.jitter + ")";
        }
    }
}

