/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CompatStyleDeclaration;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.ExtendedCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.GroupingRule;
import io.sf.carte.doc.style.css.om.RuleStore;
import io.sf.carte.doc.style.css.om.SelectorSerializer;
import io.sf.carte.doc.style.css.om.Specificity;
import io.sf.carte.doc.style.css.om.WrappedCSSStyleDeclaration;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class StyleRule
extends GroupingRule
implements CSSStyleRule,
ExtendedCSSDeclarationRule {
    private static final long serialVersionUID = 2L;
    SelectorList selectorList = null;
    private SelectorList absSelectorList = null;
    String selectorText = "";
    private BaseCSSStyleDeclaration declaration = null;
    private StyleDeclarationErrorHandler sdErrorHandler = null;

    public StyleRule(AbstractCSSStyleSheet parentSheet, int origin) {
        super(parentSheet, (short)1, origin);
        this.declaration = this.createStyleDeclaration(parentSheet);
    }

    BaseCSSStyleDeclaration createStyleDeclaration(AbstractCSSStyleSheet parentSheet) {
        return (BaseCSSStyleDeclaration)parentSheet.createStyleDeclaration(this);
    }

    @Override
    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    void setWrappedStyle(BaseCSSStyleDeclaration style, String oldHrefContext) {
        this.declaration = !(style instanceof CompatStyleDeclaration) ? new StyleWrapper(style, oldHrefContext) : new CompatStyleWrapper((CompatStyleDeclaration)style, oldHrefContext);
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return this.sdErrorHandler != null && (this.sdErrorHandler.hasErrors() || this.sdErrorHandler.hasWarnings());
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler handler) {
        this.sdErrorHandler = handler;
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        SelectorList selist;
        Parser parser = this.createSACParser();
        try {
            selist = parser.parseSelectors(selectorText, this.getParentStyleSheet());
        }
        catch (CSSException e) {
            throw new DOMSyntaxException(e);
        }
        this.setSelectorList(selist);
    }

    @Override
    public String getSelectorText() {
        return this.selectorText;
    }

    @Override
    public void setSelectorList(SelectorList selectorList) {
        if (selectorList == null) {
            throw new NullPointerException("Null selector list");
        }
        if (selectorList.getLength() == 0) {
            throw new IllegalArgumentException("Empty selector list");
        }
        this.selectorList = selectorList;
        this.updateSelectorText();
        this.updateAbsoluteSelectorList();
    }

    void updateSelectorText() {
        int sz = this.selectorList.getLength();
        StringBuilder sb = new StringBuilder(sz * 7 + 5);
        if (sz > 0) {
            SelectorSerializer serializer = new SelectorSerializer(this.getParentStyleSheet());
            serializer.selectorListText(sb, this.selectorList, false, false);
        }
        this.selectorText = sb.toString();
    }

    private void updateAbsoluteSelectorList() {
        this.absSelectorList = this.selectorList;
        AbstractCSSRule parent = this.getParentRule();
        if (parent != null) {
            LinkedList<SelectorList> selStack = new LinkedList<SelectorList>();
            AbstractCSSRule anc = null;
            do {
                if (parent.getType() != 1) continue;
                anc = parent;
                selStack.add(((StyleRule)anc).getSelectorList());
            } while ((parent = this.getParentRule()) != null);
            if (anc != null) {
                Iterator it = selStack.descendingIterator();
                this.absSelectorList = (SelectorList)it.next();
                while (it.hasNext()) {
                    SelectorList list = (SelectorList)it.next();
                    this.absSelectorList = list.replaceNested(this.absSelectorList);
                }
                this.absSelectorList = this.selectorList.replaceNested(this.absSelectorList);
            }
        }
        this.updateDescendantsAbsoluteSelectorList(this.absSelectorList);
    }

    @Override
    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    SelectorList getAbsoluteSelectorList() {
        return this.absSelectorList;
    }

    void setAbsoluteSelectorList(SelectorList absSelectorList) {
        this.absSelectorList = absSelectorList;
    }

    @Override
    void prioritySplit(AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet, RuleStore importantStore, RuleStore normalStore) {
        AbstractCSSStyleDeclaration userImportantStyle = normalSheet.createStyleDeclaration();
        AbstractCSSStyleDeclaration userNormalStyle = normalSheet.createStyleDeclaration();
        this.prioritySplit(importantSheet, normalSheet, importantStore, normalStore, userImportantStyle, userNormalStyle);
    }

    void prioritySplit(AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet, RuleStore importantStore, RuleStore normalStore, AbstractCSSStyleDeclaration userImportantStyle, AbstractCSSStyleDeclaration userNormalStyle) {
        AbstractCSSStyleDeclaration st = this.getStyle();
        st.prioritySplit(userImportantStyle, userNormalStyle);
        StyleRule importantrule = null;
        if (!userImportantStyle.isEmpty()) {
            importantrule = importantSheet.createStyleRule();
            this.copySelectorsTo(importantrule);
            BaseCSSStyleDeclaration style = (BaseCSSStyleDeclaration)importantrule.getStyle();
            style.setProperties((BaseCSSStyleDeclaration)userImportantStyle);
            importantStore.addRule(importantrule);
        }
        StyleRule normalrule = null;
        if (!userNormalStyle.isEmpty()) {
            normalrule = normalSheet.createStyleRule();
            this.copySelectorsTo(normalrule);
            BaseCSSStyleDeclaration style = (BaseCSSStyleDeclaration)normalrule.getStyle();
            style.setProperties((BaseCSSStyleDeclaration)userNormalStyle);
            normalStore.addRule(normalrule);
        }
        if (this.cssRules != null) {
            if (importantrule == null) {
                importantrule = importantSheet.createStyleRule();
                this.copySelectorsTo(importantrule);
            }
            if (normalrule == null) {
                normalrule = normalSheet.createStyleRule();
                this.copySelectorsTo(normalrule);
            }
            super.prioritySplit(importantSheet, normalSheet, importantrule, normalrule);
            if (importantrule.getParentRule() == null && importantrule.getCssRules() != null) {
                importantStore.addRule(importantrule);
            }
            if (normalrule.getParentRule() == null && normalrule.getCssRules() != null) {
                normalStore.addRule(normalrule);
            }
        }
    }

    void copySelectorsTo(StyleRule otherRule) {
        otherRule.selectorList = this.getSelectorList();
        otherRule.selectorText = this.selectorText;
        otherRule.setAbsoluteSelectorList(this.getAbsoluteSelectorList());
    }

    @Override
    void cascade(BaseDocumentCSSStyleSheet.Cascade cascade, SelectorMatcher matcher, ComputedCSSStyle style, String targetMedium) {
        int selIdx = matcher.matches(this.getAbsoluteSelectorList());
        if (selIdx != -1) {
            cascade.add(this.getSpecificity(selIdx, matcher));
        }
        if (this.cssRules != null) {
            this.cssRules.cascade(cascade, matcher, style, targetMedium);
        }
    }

    RuleSpecificity getSpecificity(int index, SelectorMatcher matcher) {
        return new RuleSpecificity(this.getAbsoluteSelectorList().item(index), matcher);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)seltext);
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            if (this.cssRules != null) {
                this.cssRules.writeCssText(wri, context);
            }
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    @Override
    public String getMinifiedCssText() {
        String seltext = this.getSelectorText();
        int len = seltext.length();
        if (len != 0) {
            String ministyle = this.getStyle().getMinifiedCssText();
            int slen = ministyle.length();
            StringBuilder buf = new StringBuilder(len + slen + 3);
            buf.append(seltext).append('{');
            if (slen > 0) {
                buf.append(ministyle);
            }
            if (this.cssRules != null) {
                if (slen > 0) {
                    buf.append(';');
                }
                buf.append(this.cssRules.toMinifiedString());
            }
            buf.append('}');
            return buf.toString();
        }
        return "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.selectorList == null ? 0 : this.selectorList.hashCode());
        result = 31 * result + this.declaration.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleRule other = (StyleRule)obj;
        return Objects.equals(this.selectorList, other.selectorList) && this.declaration.equals(other.declaration);
    }

    @Override
    public StyleRule clone(AbstractCSSStyleSheet parentSheet) throws IllegalArgumentException {
        StyleRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class, Integer.TYPE};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet, this.getOrigin()};
        try {
            rule = (StyleRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        rule.selectorList = this.getSelectorList();
        rule.selectorText = this.getSelectorText();
        rule.absSelectorList = this.getAbsoluteSelectorList();
        rule.setPrecedingComments(this.getPrecedingComments());
        rule.setTrailingComments(this.getTrailingComments());
        if (this.cssRules != null) {
            rule.cssRules = this.cloneRuleList(parentSheet, this.cssRules);
        }
        if (this.hasErrorsOrWarnings()) {
            rule.setStyleDeclarationErrorHandler(this.getStyleDeclarationErrorHandler());
        }
        return rule;
    }

    private class StyleWrapper
    extends WrappedCSSStyleDeclaration {
        private static final long serialVersionUID = 1L;

        private StyleWrapper(BaseCSSStyleDeclaration copiedObject, String oldHrefContext) {
            super(copiedObject, oldHrefContext);
        }

        @Override
        public CSSDeclarationRule getParentRule() {
            return StyleRule.this;
        }
    }

    private class CompatStyleWrapper
    extends CompatStyleDeclaration {
        private static final long serialVersionUID = 1L;
        private final String hrefcontext;
        private final String oldHrefContext;

        private CompatStyleWrapper(CompatStyleDeclaration copiedObject, String oldHrefContext) {
            super(copiedObject);
            this.hrefcontext = WrappedCSSStyleDeclaration.getHrefContext(this.getParentRule());
            this.oldHrefContext = oldHrefContext;
        }

        @Override
        protected StyleValue getCSSValue(String propertyName) {
            StyleValue value = super.getCSSValue(propertyName);
            if (value != null) {
                value = WrappedCSSStyleDeclaration.wrapCSSValue(value, this.oldHrefContext, this.hrefcontext);
            }
            return value;
        }

        @Override
        public CSSDeclarationRule getParentRule() {
            return StyleRule.this;
        }
    }

    class RuleSpecificity
    extends Specificity {
        private static final long serialVersionUID = 1L;

        public RuleSpecificity(Selector selector, SelectorMatcher matcher) {
            super(selector, matcher);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.getCSSStyleRule().getOrigin();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.getCSSStyleRule().getOrigin() == ((RuleSpecificity)obj).getCSSStyleRule().getOrigin();
        }

        public StyleRule getCSSStyleRule() {
            return StyleRule.this;
        }
    }

    static class SpecificityComparator
    implements Comparator<RuleSpecificity> {
        SpecificityComparator() {
        }

        @Override
        public int compare(RuleSpecificity o1, RuleSpecificity o2) {
            return (o2.getCSSStyleRule().getOrigin() - o1.getCSSStyleRule().getOrigin()) * 8191 + Specificity.selectorCompare(o1, o2);
        }
    }
}

