/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.spi.model.destination;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.common.Strings;
import org.opensearch.notifications.spi.model.destination.BaseDestination;
import org.opensearch.notifications.spi.model.destination.DestinationType;
import org.opensearch.notifications.spi.utils.ValidationHelpersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/notifications/spi/model/destination/SmtpDestination;", "Lorg/opensearch/notifications/spi/model/destination/BaseDestination;", "accountName", "", "host", "port", "", "method", "fromAddress", "recipient", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccountName", "()Ljava/lang/String;", "getFromAddress", "getHost", "getMethod", "getPort", "()I", "getRecipient", "opensearch-notifications-core-spi"})
@SourceDebugExtension(value={"SMAP\nSmtpDestination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmtpDestination.kt\norg/opensearch/notifications/spi/model/destination/SmtpDestination\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class SmtpDestination
extends BaseDestination {
    @NotNull
    private final String accountName;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String method;
    @NotNull
    private final String fromAddress;
    @NotNull
    private final String recipient;

    public SmtpDestination(@NotNull String accountName, @NotNull String host, int port, @NotNull String method, @NotNull String fromAddress, @NotNull String recipient) {
        Intrinsics.checkNotNullParameter((Object)accountName, (String)"accountName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)fromAddress, (String)"fromAddress");
        Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
        super(DestinationType.SMTP);
        this.accountName = accountName;
        this.host = host;
        this.port = port;
        this.method = method;
        this.fromAddress = fromAddress;
        this.recipient = recipient;
        if (!(!Strings.isNullOrEmpty((String)this.host))) {
            boolean $i$a$-require-SmtpDestination$32 = false;
            String $i$a$-require-SmtpDestination$32 = "Host name should be provided";
            throw new IllegalArgumentException($i$a$-require-SmtpDestination$32.toString());
        }
        if (!(this.port > 0)) {
            boolean bl = false;
            String string = "Port should be positive value";
            throw new IllegalArgumentException(string.toString());
        }
        ValidationHelpersKt.validateEmail(this.fromAddress);
        ValidationHelpersKt.validateEmail(this.recipient);
    }

    @NotNull
    public final String getAccountName() {
        return this.accountName;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final String getFromAddress() {
        return this.fromAddress;
    }

    @NotNull
    public final String getRecipient() {
        return this.recipient;
    }
}

