/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.util.TableUtils;
import org.protege.editor.core.update.PluginInfo;

public class PluginTable
extends JPanel {
    private JTable table;
    private PluginUpdateTableModel tableModel;
    private List<PluginInfo> provider;
    private List<ListSelectionListener> pendingListeners = new ArrayList<ListSelectionListener>();
    private ComponentAdapter componentAdapter = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent event) {
            PluginTable.this.removeComponentListener(PluginTable.this.componentAdapter);
            PluginTable.this.handleTableShown();
        }
    };
    private JLabel waitLabel;

    public PluginTable(List<PluginInfo> plugins) {
        this.setOpaque(false);
        this.provider = new ArrayList<PluginInfo>(plugins);
        this.addComponentListener(this.componentAdapter);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 200));
        this.waitLabel = new JLabel("Checking for plugins...", Icons.getIcon("busy.gif"), 0);
        this.add((Component)this.waitLabel, "Center");
        this.handleTableShown();
    }

    private void handleTableShown() {
        Thread t = new Thread(() -> {
            this.tableModel = new PluginUpdateTableModel(this.provider);
            this.table = new JTable(this.tableModel);
            this.table.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.table.setShowGrid(true);
            this.table.setRowMargin(1);
            this.table.setGridColor(new Color(220, 220, 220));
            this.table.setShowVerticalLines(false);
            this.table.setRowHeight(this.table.getRowHeight() + 5);
            this.table.setRowSelectionAllowed(true);
            this.table.setColumnSelectionAllowed(false);
            TableUtils.pack(this.table, true, false, 1);
            final JScrollPane tableSp = new JScrollPane(this.table);
            for (ListSelectionListener l : this.pendingListeners) {
                this.table.getSelectionModel().addListSelectionListener(l);
            }
            this.pendingListeners.clear();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ PluginTable this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.remove(this.this$0.waitLabel);
                    this.this$0.add((Component)tableSp, "Center");
                    this.this$0.validate();
                }
            });
        }, "Load plugin table contents");
        t.start();
    }

    public List<PluginInfo> getSelectedUpdateInfo() {
        if (this.tableModel != null) {
            return this.tableModel.getSelectedUpdateInfo();
        }
        return Collections.emptyList();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        if (this.table == null) {
            this.pendingListeners.add(l);
        } else {
            this.table.getSelectionModel().addListSelectionListener(l);
        }
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.table.getSelectionModel().removeListSelectionListener(l);
    }

    public PluginInfo getCurrentUpdateInfo() {
        if (this.table != null && this.table.getSelectedRow() >= 0) {
            return this.tableModel.getUpdateInfoAt(this.table.getSelectedRow());
        }
        return null;
    }

    private class PluginUpdateTableModel
    extends AbstractTableModel {
        private List<Boolean> install;
        private final String[] colNames = new String[]{"Install", "Name", "Current version", "Available version"};
        private List<PluginInfo> plugins;

        public PluginUpdateTableModel(List<PluginInfo> plugins) {
            this.plugins = new ArrayList<PluginInfo>(plugins);
            this.getInstallList();
        }

        public List<Boolean> getInstallList() {
            if (this.install == null) {
                this.install = new ArrayList<Boolean>(this.plugins.size());
                for (PluginInfo info : this.plugins) {
                    this.install.add(false);
                }
            }
            return this.install;
        }

        public PluginInfo getUpdateInfoAt(int index) {
            return this.plugins.get(index);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public List<PluginInfo> getSelectedUpdateInfo() {
            ArrayList<PluginInfo> sel = new ArrayList<PluginInfo>();
            int counter = 0;
            for (Boolean b : this.getInstallList()) {
                if (b.booleanValue()) {
                    sel.add(this.plugins.get(counter));
                }
                ++counter;
            }
            return sel;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return this.plugins.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.getInstallList().get(rowIndex);
            }
            PluginInfo info = this.plugins.get(rowIndex);
            if (columnIndex == 1) {
                if (info.getPluginDescriptor() != null) {
                    return info.getPluginDescriptor().getHeaders().get("Bundle-Name");
                }
                return info.getLabel();
            }
            if (columnIndex == 2) {
                Bundle bundle = info.getPluginDescriptor();
                StringBuilder versionString = new StringBuilder();
                if (bundle != null) {
                    Version version = PluginUtilities.getBundleVersion(bundle);
                    versionString.append(version.getMajor());
                    versionString.append(".");
                    versionString.append(version.getMinor());
                    versionString.append(".");
                    versionString.append(version.getMicro());
                    String qualifier = version.getQualifier();
                    if (qualifier != null && !qualifier.isEmpty()) {
                        versionString.append(".");
                        versionString.append(qualifier);
                    }
                }
                return versionString;
            }
            return info.getAvailableVersion();
        }

        @Override
        public String getColumnName(int column) {
            return this.colNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Boolean) {
                this.getInstallList().set(rowIndex, (Boolean)aValue);
            }
        }
    }
}

