/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.SensorBuilder;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsRegistry;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class ShareFetchMetricsManager {
    private final Sensor throttleTime;
    private final Sensor bytesFetched;
    private final Sensor recordsFetched;
    private final Sensor fetchLatency;
    private final Sensor sentAcknowledgements;
    private final Sensor failedAcknowledgements;

    public ShareFetchMetricsManager(Metrics metrics, ShareFetchMetricsRegistry metricsRegistry) {
        this.bytesFetched = new SensorBuilder(metrics, "bytes-fetched").withAvg(metricsRegistry.fetchSizeAvg).withMax(metricsRegistry.fetchSizeMax).withMeter(metricsRegistry.bytesFetchedRate, metricsRegistry.bytesFetchedTotal).build();
        this.recordsFetched = new SensorBuilder(metrics, "records-fetched").withAvg(metricsRegistry.recordsPerRequestAvg).withMax(metricsRegistry.recordsPerRequestMax).withMeter(metricsRegistry.recordsFetchedRate, metricsRegistry.recordsFetchedTotal).build();
        this.sentAcknowledgements = new SensorBuilder(metrics, "sent-acknowledgements").withMeter(metricsRegistry.acknowledgementSendRate, metricsRegistry.acknowledgementSendTotal).build();
        this.failedAcknowledgements = new SensorBuilder(metrics, "failed-acknowledgements").withMeter(metricsRegistry.acknowledgementErrorRate, metricsRegistry.acknowledgementErrorTotal).build();
        this.fetchLatency = new SensorBuilder(metrics, "fetch-latency").withAvg(metricsRegistry.fetchLatencyAvg).withMax(metricsRegistry.fetchLatencyMax).withMeter(new WindowedCount(), metricsRegistry.fetchRequestRate, metricsRegistry.fetchRequestTotal).build();
        this.throttleTime = new SensorBuilder(metrics, "fetch-throttle-time").withAvg(metricsRegistry.fetchThrottleTimeAvg).withMax(metricsRegistry.fetchThrottleTimeMax).build();
    }

    public Sensor throttleTimeSensor() {
        return this.throttleTime;
    }

    void recordLatency(long requestLatencyMs) {
        this.fetchLatency.record(requestLatencyMs);
    }

    void recordBytesFetched(int bytes) {
        this.bytesFetched.record(bytes);
    }

    void recordRecordsFetched(int records) {
        this.recordsFetched.record(records);
    }

    void recordAcknowledgementSent(int acknowledgements) {
        this.sentAcknowledgements.record(acknowledgements);
    }

    void recordFailedAcknowledgements(int acknowledgements) {
        this.failedAcknowledgements.record(acknowledgements);
    }
}

