/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.cert;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.cert.CertPrincipalResolver;
import org.apache.solr.security.cert.CertResolverPattern;
import org.apache.solr.security.cert.PathBasedCertResolverBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathBasedCertPrincipalResolver
extends PathBasedCertResolverBase
implements CertPrincipalResolver {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_EXTRACT = "extract";
    private static final String PARAM_AFTER = "after";
    private static final String PARAM_BEFORE = "before";
    private final CertResolverPattern pattern;
    private final String startPattern;
    private final String endPattern;

    public PathBasedCertPrincipalResolver(Map<String, Object> params) {
        this.pattern = this.createCertResolverPattern(params, "subject.dn");
        Map extractConfig = params.getOrDefault(PARAM_EXTRACT, Collections.emptyMap());
        this.startPattern = extractConfig.getOrDefault(PARAM_AFTER, "");
        this.endPattern = extractConfig.getOrDefault(PARAM_BEFORE, "");
    }

    @Override
    public Principal resolvePrincipal(X509Certificate certificate) throws SSLPeerUnverifiedException, CertificateParsingException {
        Map<String, Set<String>> matches = this.getValuesFromPaths(certificate, Collections.singletonList(this.pattern));
        String basePrincipal = null;
        if (matches != null && !matches.isEmpty()) {
            Set fieldValues = matches.getOrDefault(this.pattern.getName(), Collections.emptySet());
            basePrincipal = fieldValues.stream().findFirst().orElse(null);
        }
        log.debug("Resolved basePrincipal: {}", basePrincipal);
        if (basePrincipal == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Resolved principal is null. No principal information was found matching the configuration");
        }
        String principal = this.extractPrincipal(basePrincipal);
        log.debug("Resolved principal: {}", (Object)principal);
        return new BasicUserPrincipal(principal);
    }

    private String extractPrincipal(String str) {
        int end;
        int start = this.startPattern.isEmpty() || !str.contains(this.startPattern) ? 0 : str.indexOf(this.startPattern) + this.startPattern.length();
        int n = end = this.endPattern.isEmpty() ? str.length() : str.indexOf(this.endPattern, start);
        if (start >= 0 && end > start && end <= str.length()) {
            str = str.substring(start, end);
        }
        return str;
    }
}

