/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.TeXParser;
import java.util.Enumeration;
import java.util.Vector;

public class SkippedSpaces
extends Ignoreable {
    private Vector<Space> contents = new Vector();

    public int size() {
        return this.contents.size();
    }

    public void add(Space space) {
        this.contents.add(space);
    }

    public Space get(int n) {
        return this.contents.get(n);
    }

    public Enumeration<Space> elements() {
        return this.contents.elements();
    }

    public Vector<Space> getContents() {
        return this.contents;
    }

    @Override
    public Object clone() {
        SkippedSpaces skippedSpaces = new SkippedSpaces();
        skippedSpaces.contents.addAll(this.contents);
        return skippedSpaces;
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Space space : this.contents) {
            stringBuilder.appendCodePoint(space.getSpace());
        }
        return stringBuilder.toString();
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Space space : this.contents) {
            stringBuilder.appendCodePoint(space.getSpace());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%s[", this.getClass().getSimpleName()));
        for (Space space : this.contents) {
            stringBuilder.appendCodePoint(space.getSpace());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean containsEol() {
        for (Space space : this.contents) {
            if (!space.isEol()) continue;
            return true;
        }
        return false;
    }
}

