%%
%% This is file `nstc-cm03.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% nstc-proposal.dtx  (with options: `cm03')
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   https://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2008 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Liang-Ting Chen (陳亮廷).
%% 
%% This work consists of the files nstc-proposal.dtx and nstc-proposal.ins
%% and the derived files nstc-cm03.cls, nstc-cm302.cls,
%% example/proposal.tex, and example/bibliography.tex.
%% 
\NeedsTeXFormat{LaTeX2e}[2023-11-01]
\ProvidesClass{nstc-cm03}
   [2024-11-04 v1.0 NSTC CM03/302 LaTeX 文件格式]

\def\cmthree@opterrlong{The option "\CurrentOption" from article.cls is
  not compatible with the format of cm03.}
\newcommand{\cmthree@warning}{\ClassWarning{cm03}{\cmthree@opterrlong}}
\newcommand{\cmthree@info}[1]{\ClassInfo{cm03}{#1}}
\DeclareOption{titlepage}{\cmthree@warning}
\DeclareOption{notitlepage}{\cmthree@warning}
\DeclareOption{10pt}{\cmthree@warning}
\DeclareOption{11pt}{\cmthree@warning}
\DeclareOption{letterpaper}{\cmthree@warning}
\DeclareOption{a5paper}{\cmthree@warning}
\DeclareOption{b5paper}{\cmthree@warning}
\DeclareOption{executivepaper}{\cmthree@warning}
\DeclareOption{legalpaper}{\cmthree@warning}
\DeclareOption{twocolumn}{\cmthree@warning}
\DeclareOption{openright}{\cmthree@warning}
\DeclareOption{libertine}{\let\@libertine\relax}
\DeclareOption{kaiti}{\let\@kaiti\relax}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass[a4paper,12pt,onecolumn,twoside]{article}
\RequirePackage[margin=2cm,bottom=2.4cm]{geometry}
\RequirePackage{setspace}
\onehalfspacing

\RequirePackage{iftex,xifthen}
\RequirePackage{amsmath,amsthm}
\iftutex
\RequirePackage[PunctStyle=plain,no-math]{xeCJK}
\ifx\@kaiti\relax
  \setCJKmainfont{Kaiti TC}[BoldFont = *-Bold]
  \setCJKsansfont{Heiti TC}
  \cmthree@info{使用楷體作為中文字型}
\else
\IfFontExistsTF{BiauKai}{
  \setCJKmainfont{BiauKai}[AutoFakeBold=2.5]
  \cmthree@info{使用標楷體 (BiauKai) 作為中文字型}
}{
  \IfFontExistsTF{BiauKaiTC}{
  \setCJKmainfont{BiauKaiTC}[AutoFakeBold=2.5]
  \cmthree@info{使用標楷體繁 (BiauKaiTC) 作為中文字型}
}{
  \setCJKmainfont{bkai00mp.ttf}[AutoFakeBold=2.5]
  \cmthree@info{使用 AR PL UKai TW 作為中文字型}
}}
\fi
\else
  \RequirePackage{CJKutf8}
  \newenvironment{zh}{\begin{CJK*}{UTF8}{bkai}}{\end{CJK*}}
  \input{c70bkai.fd}
  \DeclareFontShape{C70}{bkai}{b}{n}{<-> CJKb * bkaiu}{\CJKbold}
  \AddToHook{begindocument/end}{\begin{zh}}
  \AddToHook{enddocument}{\end{zh}}
\fi
\ifx\@libertine\relax
  \RequirePackage[tt=false]{libertine}
  \iftutex
    \RequirePackage{unicode-math}
    \setmathfont[Scale=MatchUppercase]{LibertinusMath-Regular.otf}
  \else
    \RequirePackage[libertine]{newtxmath}
  \fi
\else
  \RequirePackage{newtxtext}
  \iftutex
    \defaultfontfeatures{}
  \fi
  \RequirePackage{newtxmath}
\fi
\RequirePackage{zhnumber,titlesec}
\titleformat{\section}[runin]%
  {\bfseries\normalsize}{（\zhnum{section}）}{0em}{}
\titleformat{\subsection}[runin]%
  {\bfseries\normalsize}{\thesubsection}{0.5em}{}
\titleformat{\subsubsection}[runin]%
  {\bfseries\normalsize}{\thesubsubsection}{0.5em}{}
\def\cmthree@heading{三、研究計畫內容（以中文或英文撰寫）：}
\def\cmthree@footer{表\;CM03}
\AddToHook{begindocument/end}{\par%
  \everypar={{\setbox0=\lastbox}\everypar{}}%
  \begingroup\large\bfseries\cmthree@heading\endgroup\par}

\RequirePackage{lastpage,fancyhdr}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{0pt}
\fancyhead{}
\iftutex
  \lfoot{\cmthree@footer}
\else
  \lfoot{\begin{zh}\cmthree@footer\end{zh}}
\fi
\cfoot{}
\iftutex
  \rfoot{共~\pageref{LastPage}~頁%
  \hspace{1em}第~\thepage~頁}
\else
  \rfoot{\begin{zh}共~\pageref{LastPage}~頁%
  \hspace{1em}第~\thepage~頁\end{zh}}
\fi
\AddToHook{begindocument/end}{\renewcommand{\refname}{參考文獻}}
\newcommand{\zhsection}[2]{\section{#1}#2\vskip1em}
\newcommand{\ProposalBackground}{\zhsection{研究計畫之背景}{請詳述本研究計畫所要探討或解決的問題、研究原創性、重要性、預期影響性及國內外有關本計畫之研究情況、重要參考文獻之評述等。如為連續性計畫應說明上年度研究進度。}}
\newcommand{\ProposalMethod}{\zhsection{研究方法、進行步驟及執行進度}{請分年列述：1. 本計畫採用之研究方法與原因及其創新性。2. 預計可能遭遇之困難及解決途徑。3. 重要儀器之配合使用情形。4. 如為須赴國外或大陸地區研究，請詳述其必要性以及預期效益等。}}
\newcommand{\ProposalPlan}{\zhsection{預期完成之工作項目及成果}{請分年列述：1. 預期完成之工作項目。2. 對於參與之工作人員，預期可獲之訓練。3. 預期完成之研究成果（如實務應用績效、期刊論文、研討會論文、專書、技術報告、專利或技術移轉等質與量之預期成果）。4. 學術研究、國家發展及其他應用方面預期之貢獻。}}
\newcommand{\ProposalIntegration}{\zhsection{整合型研究計畫說明}{如為整合型研究計畫請就以上各點分別說明與其他子計畫之相關性。}}

\endinput
%%
%% End of file `nstc-cm03.cls'.
