/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

public class FormattedFloatingDecimal {
    private int decExponentRounded;
    private char[] mantissa;
    private char[] exponent;
    private static final ThreadLocal<Object> threadLocalCharBuffer = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new char[20];
        }
    };

    public static FormattedFloatingDecimal valueOf(double d, int n, Form form) {
        FloatingDecimal.BinaryToASCIIConverter binaryToASCIIConverter = FloatingDecimal.getBinaryToASCIIConverter(d, form == Form.COMPATIBLE);
        return new FormattedFloatingDecimal(n, form, binaryToASCIIConverter);
    }

    private static char[] getBuffer() {
        return (char[])threadLocalCharBuffer.get();
    }

    private FormattedFloatingDecimal(int n, Form form, FloatingDecimal.BinaryToASCIIConverter binaryToASCIIConverter) {
        if (binaryToASCIIConverter.isExceptional()) {
            this.mantissa = binaryToASCIIConverter.toJavaFormatString().toCharArray();
            this.exponent = null;
            return;
        }
        char[] cArray = FormattedFloatingDecimal.getBuffer();
        int n2 = binaryToASCIIConverter.getDigits(cArray);
        int n3 = binaryToASCIIConverter.getDecimalExponent();
        boolean bl = binaryToASCIIConverter.isNegative();
        switch (form) {
            case COMPATIBLE: {
                int n4;
                this.decExponentRounded = n4 = n3;
                this.fillCompatible(n, cArray, n2, n4, bl);
                break;
            }
            case DECIMAL_FLOAT: {
                int n5 = FormattedFloatingDecimal.applyPrecision(n3, cArray, n2, n3 + n);
                this.fillDecimal(n, cArray, n2, n5, bl);
                this.decExponentRounded = n5;
                break;
            }
            case SCIENTIFIC: {
                int n6 = FormattedFloatingDecimal.applyPrecision(n3, cArray, n2, n + 1);
                this.fillScientific(n, cArray, n2, n6, bl);
                this.decExponentRounded = n6;
                break;
            }
            case GENERAL: {
                int n7 = FormattedFloatingDecimal.applyPrecision(n3, cArray, n2, n);
                if (n7 - 1 < -4 || n7 - 1 >= n) {
                    this.fillScientific(--n, cArray, n2, n7, bl);
                } else {
                    this.fillDecimal(n -= n7, cArray, n2, n7, bl);
                }
                this.decExponentRounded = n7;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public int getExponentRounded() {
        return this.decExponentRounded - 1;
    }

    public char[] getMantissa() {
        return this.mantissa;
    }

    public char[] getExponent() {
        return this.exponent;
    }

    private static int applyPrecision(int n, char[] cArray, int n2, int n3) {
        if (n3 >= n2 || n3 < 0) {
            return n;
        }
        if (n3 == 0) {
            if (cArray[0] >= '5') {
                cArray[0] = 49;
                Arrays.fill(cArray, 1, n2, '0');
                return n + 1;
            }
            Arrays.fill(cArray, 0, n2, '0');
            return n;
        }
        char c = cArray[n3];
        if (c >= '5') {
            int n4 = n3;
            if ((c = cArray[--n4]) == '9') {
                while (c == '9' && n4 > 0) {
                    c = cArray[--n4];
                }
                if (c == '9') {
                    cArray[0] = 49;
                    Arrays.fill(cArray, 1, n2, '0');
                    return n + 1;
                }
            }
            cArray[n4] = (char)(c + '\u0001');
            Arrays.fill(cArray, n4 + 1, n2, '0');
        } else {
            Arrays.fill(cArray, n3, n2, '0');
        }
        return n;
    }

    private void fillCompatible(int n, char[] cArray, int n2, int n3, boolean bl) {
        int n4;
        int n5 = n4 = bl ? 1 : 0;
        if (n3 > 0 && n3 < 8) {
            if (n2 < n3) {
                int n6 = n3 - n2;
                this.mantissa = FormattedFloatingDecimal.create(bl, n2 + n6 + 2);
                System.arraycopy(cArray, 0, this.mantissa, n4, n2);
                Arrays.fill(this.mantissa, n4 + n2, n4 + n2 + n6, '0');
                this.mantissa[n4 + n2 + n6] = 46;
                this.mantissa[n4 + n2 + n6 + 1] = 48;
            } else if (n3 < n2) {
                int n7 = Math.min(n2 - n3, n);
                this.mantissa = FormattedFloatingDecimal.create(bl, n3 + 1 + n7);
                System.arraycopy(cArray, 0, this.mantissa, n4, n3);
                this.mantissa[n4 + n3] = 46;
                System.arraycopy(cArray, n3, this.mantissa, n4 + n3 + 1, n7);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(bl, n2 + 2);
                System.arraycopy(cArray, 0, this.mantissa, n4, n2);
                this.mantissa[n4 + n2] = 46;
                this.mantissa[n4 + n2 + 1] = 48;
            }
        } else if (n3 <= 0 && n3 > -3) {
            int n8 = Math.max(0, Math.min(-n3, n));
            int n9 = Math.max(0, Math.min(n2, n + n3));
            if (n8 > 0) {
                this.mantissa = FormattedFloatingDecimal.create(bl, n8 + 2 + n9);
                this.mantissa[n4] = 48;
                this.mantissa[n4 + 1] = 46;
                Arrays.fill(this.mantissa, n4 + 2, n4 + 2 + n8, '0');
                if (n9 > 0) {
                    System.arraycopy(cArray, 0, this.mantissa, n4 + 2 + n8, n9);
                }
            } else if (n9 > 0) {
                this.mantissa = FormattedFloatingDecimal.create(bl, n8 + 2 + n9);
                this.mantissa[n4] = 48;
                this.mantissa[n4 + 1] = 46;
                System.arraycopy(cArray, 0, this.mantissa, n4 + 2, n9);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(bl, 1);
                this.mantissa[n4] = 48;
            }
        } else {
            int n10;
            int n11;
            boolean bl2;
            if (n2 > 1) {
                this.mantissa = FormattedFloatingDecimal.create(bl, n2 + 1);
                this.mantissa[n4] = cArray[0];
                this.mantissa[n4 + 1] = 46;
                System.arraycopy(cArray, 1, this.mantissa, n4 + 2, n2 - 1);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(bl, 3);
                this.mantissa[n4] = cArray[0];
                this.mantissa[n4 + 1] = 46;
                this.mantissa[n4 + 2] = 48;
            }
            boolean bl3 = bl2 = n3 <= 0;
            if (bl2) {
                n11 = -n3 + 1;
                n10 = 1;
            } else {
                n11 = n3 - 1;
                n10 = 0;
            }
            if (n11 <= 9) {
                this.exponent = FormattedFloatingDecimal.create(bl2, 1);
                this.exponent[n10] = (char)(n11 + 48);
            } else if (n11 <= 99) {
                this.exponent = FormattedFloatingDecimal.create(bl2, 2);
                this.exponent[n10] = (char)(n11 / 10 + 48);
                this.exponent[n10 + 1] = (char)(n11 % 10 + 48);
            } else {
                this.exponent = FormattedFloatingDecimal.create(bl2, 3);
                this.exponent[n10] = (char)(n11 / 100 + 48);
                this.exponent[n10 + 1] = (char)((n11 %= 100) / 10 + 48);
                this.exponent[n10 + 2] = (char)(n11 % 10 + 48);
            }
        }
    }

    private static char[] create(boolean bl, int n) {
        if (bl) {
            char[] cArray = new char[n + 1];
            cArray[0] = 45;
            return cArray;
        }
        return new char[n];
    }

    private void fillDecimal(int n, char[] cArray, int n2, int n3, boolean bl) {
        int n4;
        int n5 = n4 = bl ? 1 : 0;
        if (n3 > 0) {
            if (n2 < n3) {
                this.mantissa = FormattedFloatingDecimal.create(bl, n3);
                System.arraycopy(cArray, 0, this.mantissa, n4, n2);
                Arrays.fill(this.mantissa, n4 + n2, n4 + n3, '0');
            } else {
                int n6 = Math.min(n2 - n3, n);
                this.mantissa = FormattedFloatingDecimal.create(bl, n3 + (n6 > 0 ? n6 + 1 : 0));
                System.arraycopy(cArray, 0, this.mantissa, n4, n3);
                if (n6 > 0) {
                    this.mantissa[n4 + n3] = 46;
                    System.arraycopy(cArray, n3, this.mantissa, n4 + n3 + 1, n6);
                }
            }
        } else if (n3 <= 0) {
            int n7 = Math.max(0, Math.min(-n3, n));
            int n8 = Math.max(0, Math.min(n2, n + n3));
            if (n7 > 0) {
                this.mantissa = FormattedFloatingDecimal.create(bl, n7 + 2 + n8);
                this.mantissa[n4] = 48;
                this.mantissa[n4 + 1] = 46;
                Arrays.fill(this.mantissa, n4 + 2, n4 + 2 + n7, '0');
                if (n8 > 0) {
                    System.arraycopy(cArray, 0, this.mantissa, n4 + 2 + n7, n8);
                }
            } else if (n8 > 0) {
                this.mantissa = FormattedFloatingDecimal.create(bl, n7 + 2 + n8);
                this.mantissa[n4] = 48;
                this.mantissa[n4 + 1] = 46;
                System.arraycopy(cArray, 0, this.mantissa, n4 + 2, n8);
            } else {
                this.mantissa = FormattedFloatingDecimal.create(bl, 1);
                this.mantissa[n4] = 48;
            }
        }
    }

    private void fillScientific(int n, char[] cArray, int n2, int n3, boolean bl) {
        int n4;
        char c;
        int n5 = bl ? 1 : 0;
        int n6 = Math.max(0, Math.min(n2 - 1, n));
        if (n6 > 0) {
            this.mantissa = FormattedFloatingDecimal.create(bl, n6 + 2);
            this.mantissa[n5] = cArray[0];
            this.mantissa[n5 + 1] = 46;
            System.arraycopy(cArray, 1, this.mantissa, n5 + 2, n6);
        } else {
            this.mantissa = FormattedFloatingDecimal.create(bl, 1);
            this.mantissa[n5] = cArray[0];
        }
        if (n3 <= 0) {
            c = '-';
            n4 = -n3 + 1;
        } else {
            c = '+';
            n4 = n3 - 1;
        }
        if (n4 <= 9) {
            this.exponent = new char[]{c, '0', (char)(n4 + 48)};
        } else if (n4 <= 99) {
            this.exponent = new char[]{c, (char)(n4 / 10 + 48), (char)(n4 % 10 + 48)};
        } else {
            char c2 = (char)(n4 / 100 + 48);
            this.exponent = new char[]{c, c2, (char)((n4 %= 100) / 10 + 48), (char)(n4 % 10 + 48)};
        }
    }

    public static enum Form {
        SCIENTIFIC,
        COMPATIBLE,
        DECIMAL_FLOAT,
        GENERAL;

    }
}

