/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query.rewriters;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.query.QueryRewriter;

public class BooleanFlatteningRewriter
implements QueryRewriter {
    public static final BooleanFlatteningRewriter INSTANCE = new BooleanFlatteningRewriter();

    private BooleanFlatteningRewriter() {
    }

    @Override
    public QueryBuilder rewrite(QueryBuilder query, QueryShardContext context) {
        if (!(query instanceof BoolQueryBuilder)) {
            return query;
        }
        BoolQueryBuilder boolQuery = (BoolQueryBuilder)query;
        if (!this.needsFlattening(boolQuery)) {
            return query;
        }
        return this.flattenBoolQuery(boolQuery);
    }

    private boolean needsFlattening(BoolQueryBuilder boolQuery) {
        if (this.hasFlattenableBool(boolQuery.must(), ClauseType.MUST) || this.hasFlattenableBool(boolQuery.filter(), ClauseType.FILTER) || this.hasFlattenableBool(boolQuery.should(), ClauseType.SHOULD) || this.hasFlattenableBool(boolQuery.mustNot(), ClauseType.MUST_NOT)) {
            return true;
        }
        return this.hasNestedBoolThatNeedsFlattening(boolQuery);
    }

    private boolean hasFlattenableBool(List<QueryBuilder> clauses, ClauseType parentType) {
        for (QueryBuilder clause : clauses) {
            BoolQueryBuilder nestedBool;
            if (!(clause instanceof BoolQueryBuilder) || !this.canFlatten(nestedBool = (BoolQueryBuilder)clause, parentType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNestedBoolThatNeedsFlattening(BoolQueryBuilder boolQuery) {
        for (QueryBuilder clause : boolQuery.must()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsFlattening((BoolQueryBuilder)clause)) continue;
            return true;
        }
        for (QueryBuilder clause : boolQuery.filter()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsFlattening((BoolQueryBuilder)clause)) continue;
            return true;
        }
        for (QueryBuilder clause : boolQuery.should()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsFlattening((BoolQueryBuilder)clause)) continue;
            return true;
        }
        for (QueryBuilder clause : boolQuery.mustNot()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsFlattening((BoolQueryBuilder)clause)) continue;
            return true;
        }
        return false;
    }

    private BoolQueryBuilder flattenBoolQuery(BoolQueryBuilder original) {
        BoolQueryBuilder flattened = new BoolQueryBuilder();
        flattened.boost(original.boost());
        flattened.queryName(original.queryName());
        flattened.minimumShouldMatch(original.minimumShouldMatch());
        flattened.adjustPureNegative(original.adjustPureNegative());
        this.flattenClauses(original.must(), flattened, ClauseType.MUST);
        this.flattenClauses(original.filter(), flattened, ClauseType.FILTER);
        this.flattenClauses(original.should(), flattened, ClauseType.SHOULD);
        this.flattenClauses(original.mustNot(), flattened, ClauseType.MUST_NOT);
        return flattened;
    }

    private void flattenClauses(List<QueryBuilder> clauses, BoolQueryBuilder target, ClauseType clauseType) {
        for (QueryBuilder clause : clauses) {
            if (clause instanceof BoolQueryBuilder) {
                BoolQueryBuilder nestedBool = (BoolQueryBuilder)clause;
                if (this.canFlatten(nestedBool, clauseType)) {
                    List<QueryBuilder> nestedClauses = this.getClausesForType(nestedBool, clauseType);
                    for (QueryBuilder nestedClause : nestedClauses) {
                        if (nestedClause instanceof BoolQueryBuilder) {
                            nestedClause = this.flattenBoolQuery((BoolQueryBuilder)nestedClause);
                        }
                        this.addClauseBasedOnType(target, nestedClause, clauseType);
                    }
                    continue;
                }
                BoolQueryBuilder flattenedNested = this.flattenBoolQuery(nestedBool);
                this.addClauseBasedOnType(target, flattenedNested, clauseType);
                continue;
            }
            this.addClauseBasedOnType(target, clause, clauseType);
        }
    }

    private boolean canFlatten(BoolQueryBuilder nestedBool, ClauseType parentType) {
        if (nestedBool.boost() != 1.0f || nestedBool.queryName() != null) {
            return false;
        }
        if (parentType == ClauseType.MUST_NOT) {
            return false;
        }
        switch (parentType.ordinal()) {
            case 0: {
                return !nestedBool.must().isEmpty() && nestedBool.filter().isEmpty() && nestedBool.should().isEmpty() && nestedBool.mustNot().isEmpty();
            }
            case 1: {
                return nestedBool.must().isEmpty() && !nestedBool.filter().isEmpty() && nestedBool.should().isEmpty() && nestedBool.mustNot().isEmpty();
            }
            case 2: {
                return nestedBool.must().isEmpty() && nestedBool.filter().isEmpty() && !nestedBool.should().isEmpty() && nestedBool.mustNot().isEmpty() && nestedBool.minimumShouldMatch() == null;
            }
        }
        return false;
    }

    private List<QueryBuilder> getClausesForType(BoolQueryBuilder bool, ClauseType type) {
        switch (type.ordinal()) {
            case 0: {
                return bool.must();
            }
            case 1: {
                return bool.filter();
            }
            case 2: {
                return bool.should();
            }
            case 3: {
                return bool.mustNot();
            }
        }
        return new ArrayList<QueryBuilder>();
    }

    private void addClauseBasedOnType(BoolQueryBuilder target, QueryBuilder clause, ClauseType type) {
        switch (type.ordinal()) {
            case 0: {
                target.must(clause);
                break;
            }
            case 1: {
                target.filter(clause);
                break;
            }
            case 2: {
                target.should(clause);
                break;
            }
            case 3: {
                target.mustNot(clause);
            }
        }
    }

    @Override
    public int priority() {
        return 100;
    }

    @Override
    public String name() {
        return "boolean_flattening";
    }

    private static enum ClauseType {
        MUST,
        FILTER,
        SHOULD,
        MUST_NOT;

    }
}

