/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query.rewriters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.SearchService;
import org.opensearch.search.query.QueryRewriter;

public class TermsMergingRewriter
implements QueryRewriter {
    public static final TermsMergingRewriter INSTANCE = new TermsMergingRewriter();
    private static final int DEFAULT_MINIMUM_TERMS_TO_MERGE = 16;
    private volatile int minimumTermsToMerge = 16;

    private TermsMergingRewriter() {
    }

    public void initialize(Settings settings, ClusterSettings clusterSettings) {
        this.minimumTermsToMerge = SearchService.QUERY_REWRITING_TERMS_THRESHOLD_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SearchService.QUERY_REWRITING_TERMS_THRESHOLD_SETTING, threshold -> {
            this.minimumTermsToMerge = threshold;
        });
    }

    @Override
    public QueryBuilder rewrite(QueryBuilder query, QueryShardContext context) {
        if (!(query instanceof BoolQueryBuilder)) {
            return query;
        }
        BoolQueryBuilder boolQuery = (BoolQueryBuilder)query;
        if (!this.needsMerging(boolQuery)) {
            return query;
        }
        BoolQueryBuilder rewritten = new BoolQueryBuilder();
        rewritten.boost(boolQuery.boost());
        rewritten.queryName(boolQuery.queryName());
        rewritten.minimumShouldMatch(boolQuery.minimumShouldMatch());
        rewritten.adjustPureNegative(boolQuery.adjustPureNegative());
        this.rewriteClausesNoMerge(boolQuery.must(), rewritten::must);
        this.rewriteClauses(boolQuery.filter(), rewritten::filter);
        this.rewriteClauses(boolQuery.should(), rewritten::should);
        this.rewriteClausesNoMerge(boolQuery.mustNot(), rewritten::mustNot);
        return rewritten;
    }

    private boolean needsMerging(BoolQueryBuilder boolQuery) {
        if (this.hasMergeableTerms(boolQuery.filter()) || this.hasMergeableTerms(boolQuery.should())) {
            return true;
        }
        return this.hasNestedBoolThatNeedsMerging(boolQuery);
    }

    private boolean hasMergeableTerms(List<QueryBuilder> clauses) {
        HashMap<String, List> fieldBoosts = new HashMap<String, List>();
        for (QueryBuilder clause : clauses) {
            String field;
            if (clause instanceof TermQueryBuilder) {
                TermQueryBuilder termQuery = (TermQueryBuilder)clause;
                field = termQuery.fieldName();
                float boost = termQuery.boost();
                fieldBoosts.computeIfAbsent(field, k -> new ArrayList()).add(Float.valueOf(boost));
                List boosts = (List)fieldBoosts.get(field);
                if (boosts.size() < this.minimumTermsToMerge) continue;
                float firstBoost = ((Float)boosts.get(0)).floatValue();
                boolean sameBoost = boosts.stream().allMatch(b -> b.floatValue() == firstBoost);
                if (!sameBoost) continue;
                return true;
            }
            if (!(clause instanceof TermsQueryBuilder)) continue;
            TermsQueryBuilder termsQuery = (TermsQueryBuilder)clause;
            field = termsQuery.fieldName();
            int additionalTerms = 0;
            for (QueryBuilder other : clauses) {
                TermQueryBuilder termQuery;
                if (other == clause || !(other instanceof TermQueryBuilder) || !field.equals((termQuery = (TermQueryBuilder)other).fieldName()) || termsQuery.boost() != termQuery.boost()) continue;
                ++additionalTerms;
            }
            if (termsQuery.values().size() + additionalTerms < this.minimumTermsToMerge) continue;
            return true;
        }
        return false;
    }

    private boolean hasNestedBoolThatNeedsMerging(BoolQueryBuilder boolQuery) {
        for (QueryBuilder clause : boolQuery.must()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsMerging((BoolQueryBuilder)clause)) continue;
            return true;
        }
        for (QueryBuilder clause : boolQuery.filter()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsMerging((BoolQueryBuilder)clause)) continue;
            return true;
        }
        for (QueryBuilder clause : boolQuery.should()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsMerging((BoolQueryBuilder)clause)) continue;
            return true;
        }
        for (QueryBuilder clause : boolQuery.mustNot()) {
            if (!(clause instanceof BoolQueryBuilder) || !this.needsMerging((BoolQueryBuilder)clause)) continue;
            return true;
        }
        return false;
    }

    private void rewriteClauses(List<QueryBuilder> clauses, ClauseAdder adder) {
        HashMap<String, TermsInfo> termsMap = new HashMap<String, TermsInfo>();
        ArrayList<QueryBuilder> nonTermClauses = new ArrayList<QueryBuilder>();
        for (QueryBuilder queryBuilder : clauses) {
            TermsInfo info;
            float boost;
            String field;
            if (queryBuilder instanceof TermQueryBuilder) {
                TermQueryBuilder termQuery = (TermQueryBuilder)queryBuilder;
                field = termQuery.fieldName();
                boost = termQuery.boost();
                info = (TermsInfo)termsMap.get(field);
                if (info != null && info.boost != boost) {
                    nonTermClauses.add(queryBuilder);
                    continue;
                }
                termsMap.computeIfAbsent(field, k -> new TermsInfo(boost)).addValue(termQuery.value());
                continue;
            }
            if (queryBuilder instanceof TermsQueryBuilder) {
                TermsQueryBuilder termsQuery = (TermsQueryBuilder)queryBuilder;
                field = termsQuery.fieldName();
                boost = termsQuery.boost();
                info = (TermsInfo)termsMap.get(field);
                if (info != null && info.boost != boost) {
                    nonTermClauses.add(queryBuilder);
                    continue;
                }
                info = termsMap.computeIfAbsent(field, k -> new TermsInfo(boost));
                for (Object value : termsQuery.values()) {
                    info.addValue(value);
                }
                continue;
            }
            if (queryBuilder instanceof BoolQueryBuilder) {
                nonTermClauses.add(this.rewrite(queryBuilder, null));
                continue;
            }
            nonTermClauses.add(queryBuilder);
        }
        for (Map.Entry entry : termsMap.entrySet()) {
            String field = (String)entry.getKey();
            TermsInfo info = (TermsInfo)entry.getValue();
            if (info.values.size() == 1) {
                TermQueryBuilder termQuery = new TermQueryBuilder(field, info.values.get(0));
                if (info.boost != 1.0f) {
                    termQuery.boost(info.boost);
                }
                adder.addClause(termQuery);
                continue;
            }
            if (info.values.size() >= this.minimumTermsToMerge) {
                TermsQueryBuilder termsQuery = new TermsQueryBuilder(field, info.values);
                if (info.boost != 1.0f) {
                    termsQuery.boost(info.boost);
                }
                adder.addClause(termsQuery);
                continue;
            }
            for (Object value : info.values) {
                TermQueryBuilder termQuery = new TermQueryBuilder(field, value);
                if (info.boost != 1.0f) {
                    termQuery.boost(info.boost);
                }
                adder.addClause(termQuery);
            }
        }
        for (QueryBuilder queryBuilder : nonTermClauses) {
            adder.addClause(queryBuilder);
        }
    }

    private void rewriteClausesNoMerge(List<QueryBuilder> clauses, ClauseAdder adder) {
        for (QueryBuilder clause : clauses) {
            if (clause instanceof BoolQueryBuilder) {
                adder.addClause(this.rewrite(clause, null));
                continue;
            }
            adder.addClause(clause);
        }
    }

    @Override
    public int priority() {
        return 200;
    }

    @Override
    public String name() {
        return "terms_merging";
    }

    @FunctionalInterface
    private static interface ClauseAdder {
        public void addClause(QueryBuilder var1);
    }

    private static class TermsInfo {
        final float boost;
        final List<Object> values = new ArrayList<Object>();

        TermsInfo(float boost) {
            this.boost = boost;
        }

        void addValue(Object value) {
            this.values.add(value);
        }
    }
}

