/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers;

import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.StatementExecutionHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class JDBCDynamicResultSetExecutionHandler
extends ResultSetExecutionHandler {
    protected static Logger logger__ = Log.getClientOptimizerLogger();

    protected JDBCDynamicResultSetExecutionHandler(StatementExecutionHandler statementExecutionHandler, ResultSet resultSet) throws SQLException {
        super(statementExecutionHandler, resultSet);
    }

    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        try {
            return method.invoke((Object)this.physicalResultSet_, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            DataLogger.logThrowable(Log.getClientOptimizerLogger(), throwable);
            this.dumpLogs(throwable);
            throw throwable;
        }
    }

    protected boolean shouldDumpLogs(Throwable throwable) {
        if (this.isRepositoryConnection()) {
            return false;
        }
        String string = DataProperties.getProperty("pdq.dumpLogsOnSqlCodes");
        if (string != null) {
            return Log.isLoggable(throwable);
        }
        return false;
    }

    protected void dumpLogs(Throwable throwable) {
        if (this.shouldDumpLogs(throwable)) {
            Log.dumpRingBuffer(throwable);
        }
    }
}

