/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.api.endpoint.ZooKeeperReadApis;
import org.apache.solr.client.api.model.ZooKeeperListChildrenResponse;
import org.apache.solr.client.api.model.ZooKeeperStat;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZookeeperRead
extends AdminAPIBase
implements ZooKeeperReadApis {
    private static final String EMPTY = "empty";

    @Inject
    public ZookeeperRead(CoreContainer coreContainer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(coreContainer, req, rsp);
    }

    @PermissionName(value=PermissionNameProvider.Name.ZK_READ_PERM)
    public StreamingOutput readNode(String zkPath) {
        zkPath = this.sanitizeZkPath(zkPath);
        return this.readNodeAndAddToResponse(zkPath);
    }

    @PermissionName(value=PermissionNameProvider.Name.SECURITY_READ_PERM)
    public StreamingOutput readSecurityJsonNode() {
        return this.readNodeAndAddToResponse("/security.json");
    }

    @PermissionName(value=PermissionNameProvider.Name.ZK_READ_PERM)
    public ZooKeeperListChildrenResponse listNodes(String zkPath, Boolean includeChildren) throws Exception {
        ZooKeeperListChildrenResponse listResponse = this.instantiateJerseyResponse(ZooKeeperListChildrenResponse.class);
        zkPath = this.sanitizeZkPath(zkPath);
        try {
            Stat stat = this.coreContainer.getZkController().getZkClient().exists(zkPath, null, true);
            listResponse.stat = ZookeeperRead.createAnnotatedStatFrom(stat);
            if (includeChildren != null && !includeChildren.booleanValue()) {
                return listResponse;
            }
            List l = this.coreContainer.getZkController().getZkClient().getChildren(zkPath, null, false);
            Object prefix = zkPath.endsWith("/") ? zkPath : zkPath + "/";
            LinkedHashMap<String, Stat> stats = new LinkedHashMap<String, Stat>();
            for (String s : l) {
                try {
                    stats.put(s, this.coreContainer.getZkController().getZkClient().exists((String)prefix + s, null, false));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            HashMap<String, ZooKeeperStat> childStats = new HashMap<String, ZooKeeperStat>();
            for (Map.Entry e : stats.entrySet()) {
                childStats.put((String)e.getKey(), ZookeeperRead.createAnnotatedStatFrom((Stat)e.getValue()));
            }
            listResponse.unknownFields.put(zkPath, childStats);
            return listResponse;
        }
        catch (KeeperException.NoNodeException e) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such node :" + zkPath);
        }
    }

    private String sanitizeZkPath(String zkPath) {
        if (zkPath == null || zkPath.isEmpty()) {
            return "/";
        }
        if (zkPath.length() > 1 && zkPath.endsWith("/")) {
            return zkPath.substring(0, zkPath.length() - 1);
        }
        return zkPath;
    }

    private String guessMime(byte firstByte) {
        switch (firstByte) {
            case 123: {
                return "application/json";
            }
            case 60: 
            case 63: {
                return "application/xml; charset=UTF-8";
            }
        }
        return "application/octet-stream";
    }

    private StreamingOutput readNodeAndAddToResponse(String zkPath) {
        byte[] d = this.readPathFromZookeeper(zkPath);
        if (d == null || d.length == 0) {
            d = new byte[]{};
        }
        final byte[] bytesToWrite = d;
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                output.write(bytesToWrite);
            }
        };
    }

    private byte[] readPathFromZookeeper(String path) {
        byte[] d;
        try {
            d = this.coreContainer.getZkController().getZkClient().getData(path, null, null, false);
        }
        catch (KeeperException.NoNodeException e) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such node: " + path);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected error", (Throwable)e);
        }
        return d;
    }

    public static ZooKeeperStat createAnnotatedStatFrom(Stat stat) {
        ZooKeeperStat annotatedStat = new ZooKeeperStat();
        annotatedStat.version = stat.getVersion();
        annotatedStat.aversion = stat.getAversion();
        annotatedStat.children = stat.getNumChildren();
        annotatedStat.ctime = stat.getCtime();
        annotatedStat.cversion = stat.getCversion();
        annotatedStat.czxid = stat.getCzxid();
        annotatedStat.ephemeralOwner = stat.getEphemeralOwner();
        annotatedStat.mtime = stat.getMtime();
        annotatedStat.mzxid = stat.getMzxid();
        annotatedStat.pzxid = stat.getPzxid();
        annotatedStat.dataLength = stat.getDataLength();
        return annotatedStat;
    }
}

