/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class LambdaFunction {
    private static final boolean defaultMultiExistsMethod = true;

    public static BooleanValueStream createBooleanLambdaFunction(String name, BoolInBoolOutLambda lambda, BooleanValueStream param) {
        if (param instanceof BooleanValue) {
            return new BooleanValueInBooleanValueOutFunction(name, lambda, (BooleanValue)param);
        }
        return new BooleanStreamInBooleanStreamOutFunction(name, lambda, param);
    }

    public static BooleanValue createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValueStream param) {
        return new BooleanStreamInBooleanValueOutFunction(name, lambda, param);
    }

    public static BooleanValueStream createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValueStream param1, BooleanValueStream param2) throws SolrException {
        if (param1 instanceof BooleanValue && param2 instanceof BooleanValue) {
            return new TwoBooleanValueInBooleanValueOutFunction(name, lambda, (BooleanValue)param1, (BooleanValue)param2);
        }
        if (param1 instanceof BooleanValue) {
            return new BooleanValueBooleanStreamInBooleanStreamOutFunction(name, lambda, (BooleanValue)param1, param2);
        }
        if (param2 instanceof BooleanValue) {
            return new BooleanStreamBooleanValueInBooleanStreamOutFunction(name, lambda, param1, (BooleanValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static BooleanValue createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params) {
        return LambdaFunction.createBooleanLambdaFunction(name, lambda, params, true);
    }

    public static BooleanValue createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiBooleanValueInBooleanValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiBooleanValueInBooleanValueOutRequireOneFunction(name, lambda, params);
    }

    public static IntValueStream createIntLambdaFunction(String name, IntInIntOutLambda lambda, IntValueStream param) {
        if (param instanceof IntValue) {
            return new IntValueInIntValueOutFunction(name, lambda, (IntValue)param);
        }
        return new IntStreamInIntStreamOutFunction(name, lambda, param);
    }

    public static IntValue createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValueStream param) {
        return new IntStreamInIntValueOutFunction(name, lambda, param);
    }

    public static IntValueStream createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValueStream param1, IntValueStream param2) throws SolrException {
        if (param1 instanceof IntValue && param2 instanceof IntValue) {
            return new TwoIntValueInIntValueOutFunction(name, lambda, (IntValue)param1, (IntValue)param2);
        }
        if (param1 instanceof IntValue) {
            return new IntValueIntStreamInIntStreamOutFunction(name, lambda, (IntValue)param1, param2);
        }
        if (param2 instanceof IntValue) {
            return new IntStreamIntValueInIntStreamOutFunction(name, lambda, param1, (IntValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static IntValue createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params) {
        return LambdaFunction.createIntLambdaFunction(name, lambda, params, true);
    }

    public static IntValue createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiIntValueInIntValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiIntValueInIntValueOutRequireOneFunction(name, lambda, params);
    }

    public static LongValueStream createLongLambdaFunction(String name, LongInLongOutLambda lambda, LongValueStream param) {
        if (param instanceof LongValue) {
            return new LongValueInLongValueOutFunction(name, lambda, (LongValue)param);
        }
        return new LongStreamInLongStreamOutFunction(name, lambda, param);
    }

    public static LongValue createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValueStream param) {
        return new LongStreamInLongValueOutFunction(name, lambda, param);
    }

    public static LongValueStream createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValueStream param1, LongValueStream param2) throws SolrException {
        if (param1 instanceof LongValue && param2 instanceof LongValue) {
            return new TwoLongValueInLongValueOutFunction(name, lambda, (LongValue)param1, (LongValue)param2);
        }
        if (param1 instanceof LongValue) {
            return new LongValueLongStreamInLongStreamOutFunction(name, lambda, (LongValue)param1, param2);
        }
        if (param2 instanceof LongValue) {
            return new LongStreamLongValueInLongStreamOutFunction(name, lambda, param1, (LongValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static LongValue createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params) {
        return LambdaFunction.createLongLambdaFunction(name, lambda, params, true);
    }

    public static LongValue createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiLongValueInLongValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiLongValueInLongValueOutRequireOneFunction(name, lambda, params);
    }

    public static FloatValueStream createFloatLambdaFunction(String name, FloatInFloatOutLambda lambda, FloatValueStream param) {
        if (param instanceof FloatValue) {
            return new FloatValueInFloatValueOutFunction(name, lambda, (FloatValue)param);
        }
        return new FloatStreamInFloatStreamOutFunction(name, lambda, param);
    }

    public static FloatValue createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValueStream param) {
        return new FloatStreamInFloatValueOutFunction(name, lambda, param);
    }

    public static FloatValueStream createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValueStream param1, FloatValueStream param2) throws SolrException {
        if (param1 instanceof FloatValue && param2 instanceof FloatValue) {
            return new TwoFloatValueInFloatValueOutFunction(name, lambda, (FloatValue)param1, (FloatValue)param2);
        }
        if (param1 instanceof FloatValue) {
            return new FloatValueFloatStreamInFloatStreamOutFunction(name, lambda, (FloatValue)param1, param2);
        }
        if (param2 instanceof FloatValue) {
            return new FloatStreamFloatValueInFloatStreamOutFunction(name, lambda, param1, (FloatValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static FloatValue createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params) {
        return LambdaFunction.createFloatLambdaFunction(name, lambda, params, true);
    }

    public static FloatValue createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiFloatValueInFloatValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiFloatValueInFloatValueOutRequireOneFunction(name, lambda, params);
    }

    public static DoubleValueStream createDoubleLambdaFunction(String name, DoubleInDoubleOutLambda lambda, DoubleValueStream param) {
        if (param instanceof DoubleValue) {
            return new DoubleValueInDoubleValueOutFunction(name, lambda, (DoubleValue)param);
        }
        return new DoubleStreamInDoubleStreamOutFunction(name, lambda, param);
    }

    public static DoubleValue createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValueStream param) {
        return new DoubleStreamInDoubleValueOutFunction(name, lambda, param);
    }

    public static DoubleValueStream createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValueStream param1, DoubleValueStream param2) throws SolrException {
        if (param1 instanceof DoubleValue && param2 instanceof DoubleValue) {
            return new TwoDoubleValueInDoubleValueOutFunction(name, lambda, (DoubleValue)param1, (DoubleValue)param2);
        }
        if (param1 instanceof DoubleValue) {
            return new DoubleValueDoubleStreamInDoubleStreamOutFunction(name, lambda, (DoubleValue)param1, param2);
        }
        if (param2 instanceof DoubleValue) {
            return new DoubleStreamDoubleValueInDoubleStreamOutFunction(name, lambda, param1, (DoubleValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static DoubleValue createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params) {
        return LambdaFunction.createDoubleLambdaFunction(name, lambda, params, true);
    }

    public static DoubleValue createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiDoubleValueInDoubleValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiDoubleValueInDoubleValueOutRequireOneFunction(name, lambda, params);
    }

    public static DateValueStream createDateLambdaFunction(String name, LongInLongOutLambda lambda, DateValueStream param) {
        if (param instanceof DateValue) {
            return new DateValueInDateValueOutFunction(name, lambda, (DateValue)param);
        }
        return new DateStreamInDateStreamOutFunction(name, lambda, param);
    }

    public static DateValue createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValueStream param) {
        return new DateStreamInDateValueOutFunction(name, lambda, param);
    }

    public static DateValueStream createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValueStream param1, DateValueStream param2) throws SolrException {
        if (param1 instanceof DateValue && param2 instanceof DateValue) {
            return new TwoDateValueInDateValueOutFunction(name, lambda, (DateValue)param1, (DateValue)param2);
        }
        if (param1 instanceof DateValue) {
            return new DateValueDateStreamInDateStreamOutFunction(name, lambda, (DateValue)param1, param2);
        }
        if (param2 instanceof DateValue) {
            return new DateStreamDateValueInDateStreamOutFunction(name, lambda, param1, (DateValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static DateValue createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params) {
        return LambdaFunction.createDateLambdaFunction(name, lambda, params, true);
    }

    public static DateValue createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiDateValueInDateValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiDateValueInDateValueOutRequireOneFunction(name, lambda, params);
    }

    public static StringValueStream createStringLambdaFunction(String name, StringInStringOutLambda lambda, StringValueStream param) {
        if (param instanceof StringValue) {
            return new StringValueInStringValueOutFunction(name, lambda, (StringValue)param);
        }
        return new StringStreamInStringStreamOutFunction(name, lambda, param);
    }

    public static StringValue createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValueStream param) {
        return new StringStreamInStringValueOutFunction(name, lambda, param);
    }

    public static StringValueStream createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValueStream param1, StringValueStream param2) throws SolrException {
        if (param1 instanceof StringValue && param2 instanceof StringValue) {
            return new TwoStringValueInStringValueOutFunction(name, lambda, (StringValue)param1, (StringValue)param2);
        }
        if (param1 instanceof StringValue) {
            return new StringValueStringStreamInStringStreamOutFunction(name, lambda, (StringValue)param1, param2);
        }
        if (param2 instanceof StringValue) {
            return new StringStreamStringValueInStringStreamOutFunction(name, lambda, param1, (StringValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static StringValue createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params) {
        return LambdaFunction.createStringLambdaFunction(name, lambda, params, true);
    }

    public static StringValue createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiStringValueInStringValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiStringValueInStringValueOutRequireOneFunction(name, lambda, params);
    }

    static class MultiStringValueInStringValueOutRequireOneFunction
    extends MultiStringValueInStringValueOutFunction {
        public MultiStringValueInStringValueOutRequireOneFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public String getString() {
            int i = -1;
            String value = null;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getString();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getString();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiStringValueInStringValueOutRequireAllFunction
    extends MultiStringValueInStringValueOutFunction {
        public MultiStringValueInStringValueOutRequireAllFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public String getString() {
            String value = this.params[0].getString();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                this.temp = this.params[i].getString();
                if (this.params[i].exists()) {
                    value = this.lambda.apply(value, this.temp);
                    continue;
                }
                this.exists = false;
                value = null;
            }
            return value;
        }
    }

    static abstract class MultiStringValueInStringValueOutFunction
    extends StringValue.AbstractStringValue {
        protected final StringValue[] params;
        protected final TwoStringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected String temp = null;

        public MultiStringValueInStringValueOutFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamStringValueInStringStreamOutFunction
    extends StringValueStream.AbstractStringValueStream {
        private final StringValueStream param1;
        private final StringValue param2;
        private final TwoStringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamStringValueInStringStreamOutFunction(String name, TwoStringInStringOutLambda lambda, StringValueStream param1, StringValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String value2 = this.param2.getString();
            if (this.param2.exists()) {
                this.param1.streamStrings(value1 -> cons.accept(this.lambda.apply((String)value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringValueStringStreamInStringStreamOutFunction
    extends StringValueStream.AbstractStringValueStream {
        private final StringValue param1;
        private final StringValueStream param2;
        private final TwoStringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringValueStringStreamInStringStreamOutFunction(String name, TwoStringInStringOutLambda lambda, StringValue param1, StringValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String value1 = this.param1.getString();
            if (this.param1.exists()) {
                this.param2.streamStrings(value2 -> cons.accept(this.lambda.apply(value1, (String)value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoStringValueInStringValueOutFunction
    extends StringValue.AbstractStringValue {
        private final StringValue param1;
        private final StringValue param2;
        private final TwoStringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoStringValueInStringValueOutFunction(String name, TwoStringInStringOutLambda lambda, StringValue param1, StringValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public String getString() {
            String value = this.lambda.apply(this.param1.getString(), this.param2.getString());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamInStringValueOutFunction
    extends StringValue.AbstractStringValue
    implements Consumer<String> {
        private final StringValueStream param;
        private final TwoStringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private String value;

        public StringStreamInStringValueOutFunction(String name, TwoStringInStringOutLambda lambda, StringValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public String getString() {
            this.exists = false;
            this.param.streamStrings(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(String paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamInStringStreamOutFunction
    extends StringValueStream.AbstractStringValueStream {
        private final StringValueStream param;
        private final StringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamInStringStreamOutFunction(String name, StringInStringOutLambda lambda, StringValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            this.param.streamStrings(value -> cons.accept(this.lambda.apply((String)value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringValueInStringValueOutFunction
    extends StringValue.AbstractStringValue {
        private final StringValue param;
        private final StringInStringOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public StringValueInStringValueOutFunction(String name, StringInStringOutLambda lambda, StringValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public String getString() {
            String value = this.lambda.apply(this.param.getString());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class MultiDateValueInDateValueOutRequireOneFunction
    extends MultiDateValueInDateValueOutFunction {
        public MultiDateValueInDateValueOutRequireOneFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public long getLong() {
            int i = -1;
            long value = 0L;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getLong();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getLong();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiDateValueInDateValueOutRequireAllFunction
    extends MultiDateValueInDateValueOutFunction {
        public MultiDateValueInDateValueOutRequireAllFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public long getLong() {
            long value = this.params[0].getLong();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                value = this.lambda.apply(value, this.params[i].getLong());
                this.exists = this.params[i].exists();
            }
            return value;
        }
    }

    static abstract class MultiDateValueInDateValueOutFunction
    extends DateValue.AbstractDateValue {
        protected final DateValue[] params;
        protected final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected long temp;

        public MultiDateValueInDateValueOutFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamDateValueInDateStreamOutFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValueStream param1;
        private final DateValue param2;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateStreamDateValueInDateStreamOutFunction(String name, TwoLongInLongOutLambda lambda, DateValueStream param1, DateValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long value2 = this.param2.getLong();
            if (this.param2.exists()) {
                this.param1.streamLongs(value1 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateValueDateStreamInDateStreamOutFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValue param1;
        private final DateValueStream param2;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateValueDateStreamInDateStreamOutFunction(String name, TwoLongInLongOutLambda lambda, DateValue param1, DateValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long value1 = this.param1.getLong();
            if (this.param1.exists()) {
                this.param2.streamLongs(value2 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoDateValueInDateValueOutFunction
    extends DateValue.AbstractDateValue {
        private final DateValue param1;
        private final DateValue param2;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoDateValueInDateValueOutFunction(String name, TwoLongInLongOutLambda lambda, DateValue param1, DateValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public long getLong() {
            long value = this.lambda.apply(this.param1.getLong(), this.param2.getLong());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamInDateValueOutFunction
    extends DateValue.AbstractDateValue
    implements LongConsumer {
        private final DateValueStream param;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private long value;

        public DateStreamInDateValueOutFunction(String name, TwoLongInLongOutLambda lambda, DateValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public long getLong() {
            this.exists = false;
            this.param.streamLongs(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(long paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamInDateStreamOutFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValueStream param;
        private final LongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateStreamInDateStreamOutFunction(String name, LongInLongOutLambda lambda, DateValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.param.streamLongs(value -> cons.accept(this.lambda.apply(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateValueInDateValueOutFunction
    extends DateValue.AbstractDateValue {
        private final DateValue param;
        private final LongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public DateValueInDateValueOutFunction(String name, LongInLongOutLambda lambda, DateValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public long getLong() {
            long value = this.lambda.apply(this.param.getLong());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class MultiDoubleValueInDoubleValueOutRequireOneFunction
    extends MultiDoubleValueInDoubleValueOutFunction {
        public MultiDoubleValueInDoubleValueOutRequireOneFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public double getDouble() {
            int i = -1;
            double value = 0.0;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getDouble();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getDouble();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiDoubleValueInDoubleValueOutRequireAllFunction
    extends MultiDoubleValueInDoubleValueOutFunction {
        public MultiDoubleValueInDoubleValueOutRequireAllFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public double getDouble() {
            double value = this.params[0].getDouble();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                value = this.lambda.apply(value, this.params[i].getDouble());
                this.exists = this.params[i].exists();
            }
            return value;
        }
    }

    static abstract class MultiDoubleValueInDoubleValueOutFunction
    extends DoubleValue.AbstractDoubleValue {
        protected final DoubleValue[] params;
        protected final TwoDoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected double temp;

        public MultiDoubleValueInDoubleValueOutFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamDoubleValueInDoubleStreamOutFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final DoubleValueStream param1;
        private final DoubleValue param2;
        private final TwoDoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleStreamDoubleValueInDoubleStreamOutFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValueStream param1, DoubleValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double value2 = this.param2.getDouble();
            if (this.param2.exists()) {
                this.param1.streamDoubles(value1 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleValueDoubleStreamInDoubleStreamOutFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final DoubleValue param1;
        private final DoubleValueStream param2;
        private final TwoDoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleValueDoubleStreamInDoubleStreamOutFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue param1, DoubleValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double value1 = this.param1.getDouble();
            if (this.param1.exists()) {
                this.param2.streamDoubles(value2 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoDoubleValueInDoubleValueOutFunction
    extends DoubleValue.AbstractDoubleValue {
        private final DoubleValue param1;
        private final DoubleValue param2;
        private final TwoDoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoDoubleValueInDoubleValueOutFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue param1, DoubleValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public double getDouble() {
            double value = this.lambda.apply(this.param1.getDouble(), this.param2.getDouble());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamInDoubleValueOutFunction
    extends DoubleValue.AbstractDoubleValue
    implements DoubleConsumer {
        private final DoubleValueStream param;
        private final TwoDoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private double value;

        public DoubleStreamInDoubleValueOutFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public double getDouble() {
            this.exists = false;
            this.param.streamDoubles(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(double paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamInDoubleStreamOutFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final DoubleValueStream param;
        private final DoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleStreamInDoubleStreamOutFunction(String name, DoubleInDoubleOutLambda lambda, DoubleValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            this.param.streamDoubles(value -> cons.accept(this.lambda.apply(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleValueInDoubleValueOutFunction
    extends DoubleValue.AbstractDoubleValue {
        private final DoubleValue param;
        private final DoubleInDoubleOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public DoubleValueInDoubleValueOutFunction(String name, DoubleInDoubleOutLambda lambda, DoubleValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public double getDouble() {
            double value = this.lambda.apply(this.param.getDouble());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class MultiFloatValueInFloatValueOutRequireOneFunction
    extends MultiFloatValueInFloatValueOutFunction {
        public MultiFloatValueInFloatValueOutRequireOneFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public float getFloat() {
            int i = -1;
            float value = 0.0f;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getFloat();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getFloat();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiFloatValueInFloatValueOutRequireAllFunction
    extends MultiFloatValueInFloatValueOutFunction {
        public MultiFloatValueInFloatValueOutRequireAllFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public float getFloat() {
            float value = this.params[0].getFloat();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                value = this.lambda.apply(value, this.params[i].getFloat());
                this.exists = this.params[i].exists();
            }
            return value;
        }
    }

    static abstract class MultiFloatValueInFloatValueOutFunction
    extends FloatValue.AbstractFloatValue {
        protected final FloatValue[] params;
        protected final TwoFloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected float temp;

        public MultiFloatValueInFloatValueOutFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamFloatValueInFloatStreamOutFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final FloatValueStream param1;
        private final FloatValue param2;
        private final TwoFloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatStreamFloatValueInFloatStreamOutFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValueStream param1, FloatValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            float value2 = this.param2.getFloat();
            if (this.param2.exists()) {
                this.param1.streamFloats(value1 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatValueFloatStreamInFloatStreamOutFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final FloatValue param1;
        private final FloatValueStream param2;
        private final TwoFloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatValueFloatStreamInFloatStreamOutFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue param1, FloatValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            float value1 = this.param1.getFloat();
            if (this.param1.exists()) {
                this.param2.streamFloats(value2 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoFloatValueInFloatValueOutFunction
    extends FloatValue.AbstractFloatValue {
        private final FloatValue param1;
        private final FloatValue param2;
        private final TwoFloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoFloatValueInFloatValueOutFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue param1, FloatValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public float getFloat() {
            float value = this.lambda.apply(this.param1.getFloat(), this.param2.getFloat());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamInFloatValueOutFunction
    extends FloatValue.AbstractFloatValue
    implements FloatConsumer {
        private final FloatValueStream param;
        private final TwoFloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private float value;

        public FloatStreamInFloatValueOutFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public float getFloat() {
            this.exists = false;
            this.param.streamFloats(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(float paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamInFloatStreamOutFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final FloatValueStream param;
        private final FloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatStreamInFloatStreamOutFunction(String name, FloatInFloatOutLambda lambda, FloatValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            this.param.streamFloats(value -> cons.accept(this.lambda.apply(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatValueInFloatValueOutFunction
    extends FloatValue.AbstractFloatValue {
        private final FloatValue param;
        private final FloatInFloatOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public FloatValueInFloatValueOutFunction(String name, FloatInFloatOutLambda lambda, FloatValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public float getFloat() {
            float value = this.lambda.apply(this.param.getFloat());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class MultiLongValueInLongValueOutRequireOneFunction
    extends MultiLongValueInLongValueOutFunction {
        public MultiLongValueInLongValueOutRequireOneFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public long getLong() {
            int i = -1;
            long value = 0L;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getLong();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getLong();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiLongValueInLongValueOutRequireAllFunction
    extends MultiLongValueInLongValueOutFunction {
        public MultiLongValueInLongValueOutRequireAllFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public long getLong() {
            long value = this.params[0].getLong();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                value = this.lambda.apply(value, this.params[i].getLong());
                this.exists = this.params[i].exists();
            }
            return value;
        }
    }

    static abstract class MultiLongValueInLongValueOutFunction
    extends LongValue.AbstractLongValue {
        protected final LongValue[] params;
        protected final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected long temp;

        public MultiLongValueInLongValueOutFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamLongValueInLongStreamOutFunction
    extends LongValueStream.AbstractLongValueStream {
        private final LongValueStream param1;
        private final LongValue param2;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamLongValueInLongStreamOutFunction(String name, TwoLongInLongOutLambda lambda, LongValueStream param1, LongValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long value2 = this.param2.getLong();
            if (this.param2.exists()) {
                this.param1.streamLongs(value1 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongValueLongStreamInLongStreamOutFunction
    extends LongValueStream.AbstractLongValueStream {
        private final LongValue param1;
        private final LongValueStream param2;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongValueLongStreamInLongStreamOutFunction(String name, TwoLongInLongOutLambda lambda, LongValue param1, LongValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long value1 = this.param1.getLong();
            if (this.param1.exists()) {
                this.param2.streamLongs(value2 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoLongValueInLongValueOutFunction
    extends LongValue.AbstractLongValue {
        private final LongValue param1;
        private final LongValue param2;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoLongValueInLongValueOutFunction(String name, TwoLongInLongOutLambda lambda, LongValue param1, LongValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public long getLong() {
            long value = this.lambda.apply(this.param1.getLong(), this.param2.getLong());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamInLongValueOutFunction
    extends LongValue.AbstractLongValue
    implements LongConsumer {
        private final LongValueStream param;
        private final TwoLongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private long value;

        public LongStreamInLongValueOutFunction(String name, TwoLongInLongOutLambda lambda, LongValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public long getLong() {
            this.exists = false;
            this.param.streamLongs(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(long paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamInLongStreamOutFunction
    extends LongValueStream.AbstractLongValueStream {
        private final LongValueStream param;
        private final LongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamInLongStreamOutFunction(String name, LongInLongOutLambda lambda, LongValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.param.streamLongs(value -> cons.accept(this.lambda.apply(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongValueInLongValueOutFunction
    extends LongValue.AbstractLongValue {
        private final LongValue param;
        private final LongInLongOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public LongValueInLongValueOutFunction(String name, LongInLongOutLambda lambda, LongValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public long getLong() {
            long value = this.lambda.apply(this.param.getLong());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class MultiIntValueInIntValueOutRequireOneFunction
    extends MultiIntValueInIntValueOutFunction {
        public MultiIntValueInIntValueOutRequireOneFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public int getInt() {
            int i = -1;
            int value = 0;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getInt();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getInt();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiIntValueInIntValueOutRequireAllFunction
    extends MultiIntValueInIntValueOutFunction {
        public MultiIntValueInIntValueOutRequireAllFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public int getInt() {
            int value = this.params[0].getInt();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                value = this.lambda.apply(value, this.params[i].getInt());
                this.exists = this.params[i].exists();
            }
            return value;
        }
    }

    static abstract class MultiIntValueInIntValueOutFunction
    extends IntValue.AbstractIntValue {
        protected final IntValue[] params;
        protected final TwoIntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected int temp;

        public MultiIntValueInIntValueOutFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamIntValueInIntStreamOutFunction
    extends IntValueStream.AbstractIntValueStream {
        private final IntValueStream param1;
        private final IntValue param2;
        private final TwoIntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntStreamIntValueInIntStreamOutFunction(String name, TwoIntInIntOutLambda lambda, IntValueStream param1, IntValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            int value2 = this.param2.getInt();
            if (this.param2.exists()) {
                this.param1.streamInts(value1 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntValueIntStreamInIntStreamOutFunction
    extends IntValueStream.AbstractIntValueStream {
        private final IntValue param1;
        private final IntValueStream param2;
        private final TwoIntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntValueIntStreamInIntStreamOutFunction(String name, TwoIntInIntOutLambda lambda, IntValue param1, IntValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            int value1 = this.param1.getInt();
            if (this.param1.exists()) {
                this.param2.streamInts(value2 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoIntValueInIntValueOutFunction
    extends IntValue.AbstractIntValue {
        private final IntValue param1;
        private final IntValue param2;
        private final TwoIntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoIntValueInIntValueOutFunction(String name, TwoIntInIntOutLambda lambda, IntValue param1, IntValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public int getInt() {
            int value = this.lambda.apply(this.param1.getInt(), this.param2.getInt());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamInIntValueOutFunction
    extends IntValue.AbstractIntValue
    implements IntConsumer {
        private final IntValueStream param;
        private final TwoIntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private int value;

        public IntStreamInIntValueOutFunction(String name, TwoIntInIntOutLambda lambda, IntValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public int getInt() {
            this.exists = false;
            this.param.streamInts(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(int paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamInIntStreamOutFunction
    extends IntValueStream.AbstractIntValueStream {
        private final IntValueStream param;
        private final IntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntStreamInIntStreamOutFunction(String name, IntInIntOutLambda lambda, IntValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            this.param.streamInts(value -> cons.accept(this.lambda.apply(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntValueInIntValueOutFunction
    extends IntValue.AbstractIntValue {
        private final IntValue param;
        private final IntInIntOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public IntValueInIntValueOutFunction(String name, IntInIntOutLambda lambda, IntValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public int getInt() {
            int value = this.lambda.apply(this.param.getInt());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class MultiBooleanValueInBooleanValueOutRequireOneFunction
    extends MultiBooleanValueInBooleanValueOutFunction {
        public MultiBooleanValueInBooleanValueOutRequireOneFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public boolean getBoolean() {
            int i = -1;
            boolean value = false;
            this.exists = false;
            while (++i < this.params.length) {
                value = this.params[i].getBoolean();
                this.exists = this.params[i].exists();
                if (!this.exists) continue;
            }
            while (++i < this.params.length) {
                this.temp = this.params[i].getBoolean();
                if (!this.params[i].exists()) continue;
                value = this.lambda.apply(value, this.temp);
            }
            return value;
        }
    }

    static class MultiBooleanValueInBooleanValueOutRequireAllFunction
    extends MultiBooleanValueInBooleanValueOutFunction {
        public MultiBooleanValueInBooleanValueOutRequireAllFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params) {
            super(name, lambda, params);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.params[0].getBoolean();
            this.exists = this.params[0].exists();
            for (int i = 1; i < this.params.length && this.exists; ++i) {
                value = this.lambda.apply(value, this.params[i].getBoolean());
                this.exists = this.params[i].exists();
            }
            return value;
        }
    }

    static abstract class MultiBooleanValueInBooleanValueOutFunction
    extends BooleanValue.AbstractBooleanValue {
        protected final BooleanValue[] params;
        protected final TwoBoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        protected boolean exists = false;
        protected boolean temp;

        public MultiBooleanValueInBooleanValueOutFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params) {
            this.name = name;
            this.lambda = lambda;
            this.params = params;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, params);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, params);
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamBooleanValueInBooleanStreamOutFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValueStream param1;
        private final BooleanValue param2;
        private final TwoBoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamBooleanValueInBooleanStreamOutFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValueStream param1, BooleanValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean value2 = this.param2.getBoolean();
            if (this.param2.exists()) {
                this.param1.streamBooleans(value1 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanValueBooleanStreamInBooleanStreamOutFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValue param1;
        private final BooleanValueStream param2;
        private final TwoBoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanValueBooleanStreamInBooleanStreamOutFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue param1, BooleanValueStream param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean value1 = this.param1.getBoolean();
            if (this.param1.exists()) {
                this.param2.streamBooleans(value2 -> cons.accept(this.lambda.apply(value1, value2)));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class TwoBooleanValueInBooleanValueOutFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue param1;
        private final BooleanValue param2;
        private final TwoBoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public TwoBooleanValueInBooleanValueOutFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue param1, BooleanValue param2) {
            this.name = name;
            this.lambda = lambda;
            this.param1 = param1;
            this.param2 = param2;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.lambda.apply(this.param1.getBoolean(), this.param2.getBoolean());
            this.exists = this.param1.exists() && this.param2.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamInBooleanValueOutFunction
    extends BooleanValue.AbstractBooleanValue
    implements BooleanConsumer {
        private final BooleanValueStream param;
        private final TwoBoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;
        private boolean value;

        public BooleanStreamInBooleanValueOutFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public boolean getBoolean() {
            this.exists = false;
            this.param.streamBooleans(this);
            return this.value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void accept(boolean paramValue) {
            if (!this.exists) {
                this.exists = true;
                this.value = paramValue;
            } else {
                this.value = this.lambda.apply(this.value, paramValue);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamInBooleanStreamOutFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValueStream param;
        private final BoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamInBooleanStreamOutFunction(String name, BoolInBoolOutLambda lambda, BooleanValueStream param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            this.param.streamBooleans(value -> cons.accept(this.lambda.apply(value)));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanValueInBooleanValueOutFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue param;
        private final BoolInBoolOutLambda lambda;
        private final String name;
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public BooleanValueInBooleanValueOutFunction(String name, BoolInBoolOutLambda lambda, BooleanValue param) {
            this.name = name;
            this.lambda = lambda;
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.lambda.apply(this.param.getBoolean());
            this.exists = this.param.exists();
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    @FunctionalInterface
    public static interface TwoStringInStringOutLambda {
        public String apply(String var1, String var2);
    }

    @FunctionalInterface
    public static interface TwoDoubleInStringOutLambda {
        public String apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInStringOutLambda {
        public String apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInStringOutLambda {
        public String apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInStringOutLambda {
        public String apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInStringOutLambda {
        public String apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInDoubleOutLambda {
        public double apply(String var1, String var2);
    }

    @FunctionalInterface
    public static interface TwoDoubleInDoubleOutLambda {
        public double apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInDoubleOutLambda {
        public double apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInDoubleOutLambda {
        public double apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInDoubleOutLambda {
        public double apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInDoubleOutLambda {
        public double apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInFloatOutLambda {
        public float apply(String var1, String var2);
    }

    @FunctionalInterface
    public static interface TwoDoubleInFloatOutLambda {
        public float apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInFloatOutLambda {
        public float apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInFloatOutLambda {
        public float apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInFloatOutLambda {
        public float apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInFloatOutLambda {
        public float apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInLongOutLambda {
        public long apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoDoubleInLongOutLambda {
        public long apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInLongOutLambda {
        public long apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInLongOutLambda {
        public long apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInLongOutLambda {
        public long apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInLongOutLambda {
        public long apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInIntOutLambda {
        public int apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoDoubleInIntOutLambda {
        public int apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInIntOutLambda {
        public int apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInIntOutLambda {
        public int apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInIntOutLambda {
        public int apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInIntOutLambda {
        public int apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInBoolOutLambda {
        public boolean apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoDoubleInBoolOutLambda {
        public boolean apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInBoolOutLambda {
        public boolean apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInBoolOutLambda {
        public boolean apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInBoolOutLambda {
        public boolean apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInBoolOutLambda {
        public boolean apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface StringInStringOutLambda {
        public String apply(String var1);
    }

    @FunctionalInterface
    public static interface DoubleInStringOutLambda {
        public String apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInStringOutLambda {
        public String apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInStringOutLambda {
        public String apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInStringOutLambda {
        public String apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInStringOutLambda {
        public String apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInDoubleOutLambda {
        public double apply(String var1);
    }

    @FunctionalInterface
    public static interface DoubleInDoubleOutLambda {
        public double apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInDoubleOutLambda {
        public double apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInDoubleOutLambda {
        public double apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInDoubleOutLambda {
        public double apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInDoubleOutLambda {
        public double apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInFloatOutLambda {
        public float apply(String var1);
    }

    @FunctionalInterface
    public static interface DoubleInFloatOutLambda {
        public float apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInFloatOutLambda {
        public float apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInFloatOutLambda {
        public float apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInFloatOutLambda {
        public float apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInFloatOutLambda {
        public float apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInLongOutLambda {
        public long apply(double var1);
    }

    @FunctionalInterface
    public static interface DoubleInLongOutLambda {
        public long apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInLongOutLambda {
        public long apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInLongOutLambda {
        public long apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInLongOutLambda {
        public long apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInLongOutLambda {
        public long apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInIntOutLambda {
        public int apply(double var1);
    }

    @FunctionalInterface
    public static interface DoubleInIntOutLambda {
        public int apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInIntOutLambda {
        public int apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInIntOutLambda {
        public int apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInIntOutLambda {
        public int apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInIntOutLambda {
        public int apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInBoolOutLambda {
        public boolean apply(double var1);
    }

    @FunctionalInterface
    public static interface DoubleInBoolOutLambda {
        public boolean apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInBoolOutLambda {
        public boolean apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInBoolOutLambda {
        public boolean apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInBoolOutLambda {
        public boolean apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInBoolOutLambda {
        public boolean apply(boolean var1);
    }
}

