/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.Constants;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BioSender
extends AbstractSender {
    private static final Log log = LogFactory.getLog(BioSender.class);
    protected static final StringManager sm = StringManager.getManager(BioSender.class);
    private Socket socket = null;
    private OutputStream soOut = null;
    private InputStream soIn = null;
    protected final XByteBuffer ackbuf = new XByteBuffer(Constants.ACK_COMMAND.length, true);

    @Override
    public void connect() throws IOException {
        this.openSocket();
    }

    @Override
    public void disconnect() {
        boolean bl = this.isConnected();
        this.closeSocket();
        if (bl && log.isDebugEnabled()) {
            log.debug((Object)sm.getString("bioSender.disconnect", this.getAddress().getHostAddress(), this.getPort(), 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] byArray, boolean bl) throws IOException {
        block9: {
            IOException iOException = null;
            this.setAttempt(0);
            try {
                this.pushMessage(byArray, false, bl);
            }
            catch (IOException iOException2) {
                SenderState.getSenderState(this.getDestination()).setSuspect();
                iOException = iOException2;
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("bioSender.send.again", this.getAddress().getHostAddress(), this.getPort()), (Throwable)iOException2);
                }
                while (this.getAttempt() < this.getMaxRetryAttempts()) {
                    try {
                        this.setAttempt(this.getAttempt() + 1);
                        this.pushMessage(byArray, true, bl);
                        iOException = null;
                    }
                    catch (IOException iOException3) {
                        iOException = iOException3;
                        this.closeSocket();
                    }
                }
            }
            finally {
                this.setRequestCount(this.getRequestCount() + 1);
                this.keepalive();
                if (iOException == null) break block9;
                throw iOException;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSender[(");
        stringBuilder.append(super.toString()).append(')');
        stringBuilder.append(this.getAddress()).append(':').append(this.getPort()).append(']');
        return stringBuilder.toString();
    }

    protected void openSocket() throws IOException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getAddress(), this.getPort());
            this.socket.connect(inetSocketAddress, (int)this.getTimeout());
            this.socket.setSendBufferSize(this.getTxBufSize());
            this.socket.setReceiveBufferSize(this.getRxBufSize());
            this.socket.setSoTimeout((int)this.getTimeout());
            this.socket.setTcpNoDelay(this.getTcpNoDelay());
            this.socket.setKeepAlive(this.getSoKeepAlive());
            this.socket.setReuseAddress(this.getSoReuseAddress());
            this.socket.setOOBInline(this.getOoBInline());
            this.socket.setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
            this.socket.setTrafficClass(this.getSoTrafficClass());
            this.setConnected(true);
            this.soOut = this.socket.getOutputStream();
            this.soIn = this.socket.getInputStream();
            this.setRequestCount(0);
            this.setConnectTime(System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("bioSender.openSocket", this.getAddress().getHostAddress(), this.getPort(), 0L));
            }
        }
        catch (IOException iOException) {
            SenderState.getSenderState(this.getDestination()).setSuspect();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("bioSender.openSocket.failure", this.getAddress().getHostAddress(), this.getPort(), 0L), (Throwable)iOException);
            }
            throw iOException;
        }
    }

    protected void closeSocket() {
        if (this.isConnected()) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.socket = null;
                    this.soOut = null;
                    this.soIn = null;
                }
            }
            this.setRequestCount(0);
            this.setConnected(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("bioSender.closeSocket", this.getAddress().getHostAddress(), this.getPort(), 0L));
            }
        }
    }

    protected void pushMessage(byte[] byArray, boolean bl, boolean bl2) throws IOException {
        this.keepalive();
        if (bl) {
            this.closeSocket();
        }
        if (!this.isConnected()) {
            this.openSocket();
        }
        this.soOut.write(byArray);
        this.soOut.flush();
        if (bl2) {
            this.waitForAck();
        }
        SenderState.getSenderState(this.getDestination()).setReady();
    }

    protected void waitForAck() throws IOException {
        try {
            boolean bl = false;
            boolean bl2 = false;
            this.ackbuf.clear();
            int n = this.soIn.read();
            for (int i = 0; n != -1 && i < Constants.ACK_COMMAND.length; ++i) {
                byte by = (byte)n;
                this.ackbuf.append(by);
                if (this.ackbuf.doesPackageExist()) {
                    byte[] byArray = this.ackbuf.extractDataPackage(true).getBytes();
                    bl = Arrays.equals(byArray, Constants.ACK_DATA);
                    bl2 = Arrays.equals(byArray, Constants.FAIL_ACK_DATA);
                    bl = bl || bl2;
                    break;
                }
                n = this.soIn.read();
            }
            if (!bl) {
                if (n == -1) {
                    throw new IOException(sm.getString("bioSender.ack.eof", this.getAddress(), this.socket.getLocalPort()));
                }
                throw new IOException(sm.getString("bioSender.ack.wrong", this.getAddress(), this.socket.getLocalPort()));
            }
            if (bl2 && this.getThrowOnFailedAck()) {
                throw new RemoteProcessException(sm.getString("bioSender.fail.AckReceived"));
            }
        }
        catch (IOException iOException) {
            String string = sm.getString("bioSender.ack.missing", this.getAddress(), this.socket.getLocalPort(), this.getTimeout());
            if (SenderState.getSenderState(this.getDestination()).isReady()) {
                SenderState.getSenderState(this.getDestination()).setSuspect();
                if (log.isWarnEnabled()) {
                    log.warn((Object)string, (Throwable)iOException);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)string, (Throwable)iOException);
            }
            throw iOException;
        }
        finally {
            this.ackbuf.clear();
        }
    }
}

